/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class PacketBattleInfo {
    private int battleID;
    private Collection<Integer> sideA;
    private Collection<Integer> sideB;
    private long decisionNanos;
    private long maxDecisionNanos;
    private boolean turnTimerEnabled;

    public PacketBattleInfo() {
        this.battleID = 0;
        this.sideA = new ArrayList<Integer>();
        this.sideB = new ArrayList<Integer>();
        this.maxDecisionNanos = this.decisionNanos = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
        this.turnTimerEnabled = false;
    }

    public PacketBattleInfo(int battleID, Collection<Integer> sideA, Collection<Integer> sideB, long decisionNanos, long maxDecisionNanos, boolean turnTimerEnabled) {
        this.battleID = battleID;
        this.sideA = sideA;
        this.sideB = sideB;
        this.decisionNanos = decisionNanos;
        this.maxDecisionNanos = maxDecisionNanos;
        this.turnTimerEnabled = turnTimerEnabled;
    }

    public static class Consumer
    implements BiConsumer<PacketBattleInfo, CustomPayloadEvent.Context> {
        @Override
        public void accept(PacketBattleInfo pkt, CustomPayloadEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                Entity e;
                if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
                    TurnBasedMinecraftMod.proxy.createLocalBattle(pkt.battleID);
                }
                TurnBasedMinecraftMod.proxy.getLocalBattle().clearCombatants();
                for (Integer id : pkt.sideA) {
                    e = Minecraft.getInstance().level.getEntity(id.intValue());
                    if (e == null) continue;
                    TurnBasedMinecraftMod.proxy.getLocalBattle().addCombatantToSideA(e);
                }
                for (Integer id : pkt.sideB) {
                    e = Minecraft.getInstance().level.getEntity(id.intValue());
                    if (e == null) continue;
                    TurnBasedMinecraftMod.proxy.getLocalBattle().addCombatantToSideB(e);
                }
                TurnBasedMinecraftMod.proxy.setBattleGuiAsGui();
                TurnBasedMinecraftMod.proxy.setBattleGuiTime((int)(pkt.decisionNanos / 1000000000L));
                TurnBasedMinecraftMod.proxy.setBattleGuiBattleChanged();
                TurnBasedMinecraftMod.proxy.setBattleGuiTurnTimerEnabled(pkt.turnTimerEnabled);
                TurnBasedMinecraftMod.proxy.setBattleGuiTurnTimerMax((int)(pkt.maxDecisionNanos / 1000000000L));
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class Decoder
    implements Function<RegistryFriendlyByteBuf, PacketBattleInfo> {
        @Override
        public PacketBattleInfo apply(RegistryFriendlyByteBuf buf) {
            int i;
            int battleID = buf.readInt();
            int sideACount = buf.readInt();
            int sideBCount = buf.readInt();
            ArrayList<Integer> sideA = new ArrayList<Integer>(sideACount);
            ArrayList<Integer> sideB = new ArrayList<Integer>(sideBCount);
            for (i = 0; i < sideACount; ++i) {
                sideA.add(buf.readInt());
            }
            for (i = 0; i < sideBCount; ++i) {
                sideB.add(buf.readInt());
            }
            long decisionNanos = buf.readLong();
            long maxDecisionNanos = buf.readLong();
            boolean turnTimerEnabled = buf.readBoolean();
            return new PacketBattleInfo(battleID, sideA, sideB, decisionNanos, maxDecisionNanos, turnTimerEnabled);
        }
    }

    public static class Encoder
    implements BiConsumer<PacketBattleInfo, RegistryFriendlyByteBuf> {
        @Override
        public void accept(PacketBattleInfo msg, RegistryFriendlyByteBuf buf) {
            buf.writeInt(msg.battleID);
            buf.writeInt(msg.sideA.size());
            buf.writeInt(msg.sideB.size());
            for (Integer id : msg.sideA) {
                buf.writeInt(id.intValue());
            }
            for (Integer id : msg.sideB) {
                buf.writeInt(id.intValue());
            }
            buf.writeLong(msg.decisionNanos);
            buf.writeLong(msg.maxDecisionNanos);
            buf.writeBoolean(msg.turnTimerEnabled);
        }
    }
}

