/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class PacketBattlePing {
    private int battleID;
    private int decisionSeconds;

    public PacketBattlePing() {
        this.battleID = 0;
        this.decisionSeconds = 1;
    }

    public PacketBattlePing(int battleID, int decisionSeconds) {
        this.battleID = battleID;
        this.decisionSeconds = decisionSeconds;
    }

    public static class Consumer
    implements BiConsumer<PacketBattlePing, CustomPayloadEvent.Context> {
        @Override
        public void accept(PacketBattlePing pkt, CustomPayloadEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
                    TurnBasedMinecraftMod.proxy.setBattleGuiAsGui();
                    TurnBasedMinecraftMod.proxy.setBattleGuiBattleChanged();
                    TurnBasedMinecraftMod.proxy.setBattleGuiTime(pkt.decisionSeconds);
                    TurnBasedMinecraftMod.proxy.pauseMCMusic();
                }
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class Decoder
    implements Function<RegistryFriendlyByteBuf, PacketBattlePing> {
        @Override
        public PacketBattlePing apply(RegistryFriendlyByteBuf buf) {
            return new PacketBattlePing(buf.readInt(), buf.readInt());
        }
    }

    public static class Encoder
    implements BiConsumer<PacketBattlePing, RegistryFriendlyByteBuf> {
        @Override
        public void accept(PacketBattlePing pkt, RegistryFriendlyByteBuf buf) {
            buf.writeInt(pkt.battleID);
            buf.writeInt(pkt.decisionSeconds);
        }
    }
}

