/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.TBMButtonPress;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntitySelectionButton
extends AbstractButton {
    TBMButtonPress onPress;
    private int entityID;
    private boolean isSideA;

    public EntitySelectionButton(int x, int y, int widthIn, int heightIn, String buttonText, int entityID, boolean isSideA, TBMButtonPress onPress) {
        super(x, y, widthIn, heightIn, (Component)Component.literal((String)buttonText));
        this.onPress = onPress;
        this.entityID = entityID;
        this.isSideA = isSideA;
    }

    public EntitySelectionButton(int x, int y, int widthIn, int heightIn, Component buttonTextComponent, int entityID, boolean isSideA, TBMButtonPress onPress) {
        super(x, y, widthIn, heightIn, buttonTextComponent);
        this.onPress = onPress;
        this.entityID = entityID;
        this.isSideA = isSideA;
    }

    public int getID() {
        return this.entityID;
    }

    public boolean getIsSideA() {
        return this.isSideA;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity e = Minecraft.getInstance().level.getEntity(this.entityID);
        if (e != null && e instanceof LivingEntity && ((LivingEntity)e).isAlive()) {
            int xoffset;
            int health = (int)(((LivingEntity)e).getHealth() + 0.5f);
            int xpos = this.getX();
            if (this.isSideA) {
                xpos += this.getWidth() + 4;
                xoffset = 4;
            } else {
                xpos -= 6;
                xoffset = -4;
            }
            if (health > 200) {
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 4 / 5, xpos + 2, this.getY() + this.getHeight(), -65536);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 3 / 5, xpos + 2, this.getY() + this.getHeight() * 4 / 5, -256);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 2 / 5, xpos + 2, this.getY() + this.getHeight() * 3 / 5, -16711936);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() / 5, xpos + 2, this.getY() + this.getHeight() * 2 / 5, -16711681);
                guiGraphics.fill(xpos, this.getY(), xpos + 2, this.getY() + this.getHeight() / 5, -16776961);
                int healthHeight = (health - 200) * this.getHeight() / 100;
                guiGraphics.fill(xpos + xoffset, this.getY() + this.getHeight() - healthHeight, xpos + xoffset + 2, this.getY() + this.getHeight(), -1);
            } else if (health > 100) {
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 4 / 5, xpos + 2, this.getY() + this.getHeight(), -65536);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 3 / 5, xpos + 2, this.getY() + this.getHeight() * 4 / 5, -256);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 2 / 5, xpos + 2, this.getY() + this.getHeight() * 3 / 5, -16711936);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() / 5, xpos + 2, this.getY() + this.getHeight() * 2 / 5, -16711681);
                int healthHeight = (health - 100) * this.getHeight() / 100;
                guiGraphics.fill(xpos + xoffset, this.getY() + this.getHeight() - healthHeight, xpos + xoffset + 2, this.getY() + this.getHeight(), -16776961);
            } else if (health > 50) {
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 4 / 5, xpos + 2, this.getY() + this.getHeight(), -65536);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 3 / 5, xpos + 2, this.getY() + this.getHeight() * 4 / 5, -256);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 2 / 5, xpos + 2, this.getY() + this.getHeight() * 3 / 5, -16711936);
                int healthHeight = (health - 50) * this.getHeight() / 50;
                guiGraphics.fill(xpos + xoffset, this.getY() + this.getHeight() - healthHeight, xpos + xoffset + 2, this.getY() + this.getHeight(), -16711681);
            } else if (health > 20) {
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 4 / 5, xpos + 2, this.getY() + this.getHeight(), -65536);
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 3 / 5, xpos + 2, this.getY() + this.getHeight() * 4 / 5, -256);
                int healthHeight = (health - 20) * this.getHeight() / 30;
                guiGraphics.fill(xpos + xoffset, this.getY() + this.getHeight() - healthHeight, xpos + xoffset + 2, this.getY() + this.getHeight(), -16711936);
            } else if (health > 10) {
                guiGraphics.fill(xpos, this.getY() + this.getHeight() * 4 / 5, xpos + 2, this.getY() + this.getHeight(), -65536);
                int healthHeight = (health - 10) * this.getHeight() / 10;
                guiGraphics.fill(xpos + xoffset, this.getY() + this.getHeight() - healthHeight, xpos + xoffset + 2, this.getY() + this.getHeight(), -256);
            } else {
                int healthHeight = health * this.getHeight() / 10;
                guiGraphics.fill(xpos + xoffset, this.getY() + this.getHeight() - healthHeight, xpos + xoffset + 2, this.getY() + this.getHeight(), -65536);
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
        p_259858_.add(NarratedElementType.HINT, TurnBasedMinecraftMod.proxy.getEntity(this.entityID, (ResourceKey<Level>)Minecraft.getInstance().level.dimension()).getName());
    }

    public void onPress() {
        this.onPress.onPress(this);
    }
}

