/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.EntitySelectionButton;
import com.burnedkirby.TurnBasedMinecraft.client.ItemSelectionButton;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.Combatant;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class BattleGui
extends Screen {
    private AtomicInteger timeRemaining = new AtomicInteger(15);
    private int timerMax = this.timeRemaining.get();
    private boolean turnTimerEnabled;
    private long lastInstant = System.nanoTime();
    private long elapsedTime = 0L;
    private MenuState state = MenuState.MAIN_MENU;
    private boolean stateChanged = true;
    private String info;

    public BattleGui() {
        super((Component)Component.literal((String)"Battle Gui"));
    }

    private void setState(MenuState state) {
        this.state = state;
        this.stateChanged = true;
    }

    public void turnBegin() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.ACTION);
        }
        this.setState(MenuState.WAITING);
    }

    public void turnEnd() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.DECISION);
        }
        this.timeRemaining.set(this.timerMax);
        this.elapsedTime = 0L;
        this.lastInstant = System.nanoTime();
        this.setState(MenuState.MAIN_MENU);
    }

    public void battleChanged() {
        this.stateChanged = true;
    }

    public void updateState() {
        if (!this.stateChanged) {
            return;
        }
        this.stateChanged = false;
        this.clearWidgets();
        switch (this.state) {
            case MAIN_MENU: {
                this.info = "What will you do?";
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Attack"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.ATTACK)).bounds(this.width * 3 / 7 - 25, 40, 50, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Defend"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.DEFEND)).bounds(this.width * 4 / 7 - 25, 40, 50, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Item"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.ITEM)).bounds(this.width * 3 / 7 - 25, 60, 50, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Flee"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.FLEE)).bounds(this.width * 4 / 7 - 25, 60, 50, 20).build());
                break;
            }
            case ATTACK_TARGET: {
                this.info = "Who will you attack?";
                int y = 30;
                try {
                    for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideAEntrySet()) {
                        if (e.getValue().entity != null) {
                            this.addRenderableWidget(new EntitySelectionButton(this.width / 4 - 60, y, 120, 20, e.getValue().entity.getDisplayName(), (int)e.getKey(), true, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        } else {
                            this.addRenderableWidget(new EntitySelectionButton(this.width / 4 - 60, y, 120, 20, "Unknown", (int)e.getKey(), true, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        }
                        y += 20;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                y = 30;
                try {
                    for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideBEntrySet()) {
                        if (e.getValue().entity != null) {
                            this.addRenderableWidget(new EntitySelectionButton(this.width * 3 / 4 - 60, y, 120, 20, e.getValue().entity.getDisplayName(), (int)e.getKey(), false, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        } else {
                            this.addRenderableWidget(new EntitySelectionButton(this.width * 3 / 4 - 60, y, 120, 20, "Unknown", (int)e.getKey(), false, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        }
                        y += 20;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).bounds(this.width / 2 - 30, this.height - 120, 60, 20).build());
                break;
            }
            case ITEM_ACTION: {
                this.info = "What will you do with an item?";
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Switch Held"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.SWITCH_HELD_ITEM)).bounds(this.width / 4 - 40, this.height - 120, 80, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Use"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.DECIDE_USE_ITEM)).bounds(this.width * 2 / 4 - 40, this.height - 120, 80, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).bounds(this.width * 3 / 4 - 40, this.height - 120, 80, 20).build());
                break;
            }
            case WAITING: {
                this.info = "Waiting...";
                break;
            }
            case SWITCH_ITEM: {
                this.info = "To which item will you switch to?";
                for (int i = 0; i < 9; ++i) {
                    this.addRenderableWidget(new ItemSelectionButton(this.width / 2 - 88 + i * 20, this.height - 19, 16, 16, i, button -> this.itemButtonActionEvent(button, ButtonAction.DO_ITEM_SWITCH)));
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).bounds(this.width / 2 - 40, this.height - 120, 80, 20).build());
                break;
            }
            case USE_ITEM: {
                this.info = "Which item will you use?";
                for (int i = 0; i < 9; ++i) {
                    this.addRenderableWidget(new ItemSelectionButton(this.width / 2 - 88 + i * 20, this.height - 19, 16, 16, i, button -> this.itemButtonActionEvent(button, ButtonAction.DO_USE_ITEM)));
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).bounds(this.width / 2 - 40, this.height - 120, 80, 20).build());
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
            this.drawString(guiGraphics, "Waiting...", this.width / 2 - 50, this.height / 2, -1);
            return;
        }
        if (TurnBasedMinecraftMod.proxy.getLocalBattle().getState() == Battle.State.DECISION && this.timeRemaining.get() > 0) {
            long nextInstant = System.nanoTime();
            this.elapsedTime += nextInstant - this.lastInstant;
            this.lastInstant = nextInstant;
            while (this.elapsedTime > 1000000000L) {
                this.elapsedTime -= 1000000000L;
                this.timeRemaining.decrementAndGet();
            }
        }
        this.updateState();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Object timeRemainingString = "Time remaining: ";
        int timeRemainingInt = this.timeRemaining.get();
        timeRemainingString = timeRemainingInt > 8 || !this.turnTimerEnabled ? (String)timeRemainingString + "\u00a7a" : (timeRemainingInt > 4 ? (String)timeRemainingString + "\u00a7e" : (String)timeRemainingString + "\u00a7c");
        timeRemainingString = !this.turnTimerEnabled ? (String)timeRemainingString + "Infinity" : (String)timeRemainingString + Integer.toString(timeRemainingInt);
        int stringWidth = this.font.width((String)timeRemainingString);
        guiGraphics.fill(this.width / 2 - stringWidth / 2, 5, this.width / 2 + stringWidth / 2, 15, 0x70000000);
        this.drawString(guiGraphics, (String)timeRemainingString, this.width / 2 - stringWidth / 2, 5, -1);
        stringWidth = this.font.width(this.info);
        guiGraphics.fill(this.width / 2 - stringWidth / 2, 20, this.width / 2 + stringWidth / 2, 30, 0x70000000);
        this.drawString(guiGraphics, this.info, this.width / 2 - stringWidth / 2, 20, -1);
    }

    protected void buttonActionEvent(AbstractButton button, ButtonAction action) {
        switch (action) {
            case ATTACK: {
                this.setState(MenuState.ATTACK_TARGET);
                break;
            }
            case DEFEND: {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.DEFEND, 0)});
                this.setState(MenuState.WAITING);
                break;
            }
            case ITEM: {
                this.setState(MenuState.ITEM_ACTION);
                break;
            }
            case FLEE: {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.FLEE, 0)});
                this.setState(MenuState.WAITING);
                break;
            }
            case ATTACK_TARGET: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case SWITCH_HELD_ITEM: {
                this.setState(MenuState.SWITCH_ITEM);
                break;
            }
            case DECIDE_USE_ITEM: {
                this.setState(MenuState.USE_ITEM);
                break;
            }
            case CANCEL: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case DO_ITEM_SWITCH: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case DO_USE_ITEM: {
                this.setState(MenuState.MAIN_MENU);
            }
        }
    }

    protected void entityButtonActionEvent(EntitySelectionButton button, ButtonAction action) {
        if (action.equals((Object)ButtonAction.ATTACK_TARGET)) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.ATTACK, button.getID())});
            this.setState(MenuState.WAITING);
        } else {
            this.setState(MenuState.MAIN_MENU);
        }
    }

    protected void itemButtonActionEvent(ItemSelectionButton button, ButtonAction action) {
        switch (action) {
            case DO_ITEM_SWITCH: {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.SWITCH_ITEM, button.getID())});
                if (button.getID() >= 0 && button.getID() < 9) {
                    Minecraft.getInstance().player.getInventory().selected = button.getID();
                }
                this.setState(MenuState.WAITING);
                break;
            }
            case DO_USE_ITEM: {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.USE_ITEM, button.getID())});
                this.setState(MenuState.WAITING);
                break;
            }
            default: {
                this.setState(MenuState.MAIN_MENU);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int a, int b, int c) {
        if (this.getMinecraft().player.isCreative()) {
            return super.keyPressed(a, b, c);
        }
        return false;
    }

    public boolean keyReleased(int a, int b, int c) {
        if (this.getMinecraft().player.isCreative()) {
            return super.keyReleased(a, b, c);
        }
        return false;
    }

    public void setTimeRemaining(int remaining) {
        this.timeRemaining.set(remaining);
    }

    private void drawString(GuiGraphics guiGraphics, String string, int x, int y, int color) {
        guiGraphics.drawString(this.font, string, x, y, color);
    }

    public void setTurnTimerEnabled(boolean enabled) {
        this.turnTimerEnabled = enabled;
    }

    public void setTurnTimerMax(int timerMax) {
        this.timerMax = timerMax;
    }

    public void renderBackground(GuiGraphics p_283688_, int p_296369_, int p_296477_, float p_294317_) {
    }

    private static enum MenuState {
        MAIN_MENU(0),
        ATTACK_TARGET(1),
        ITEM_ACTION(2),
        WAITING(3),
        SWITCH_ITEM(4),
        USE_ITEM(5);

        private int value;
        private static Map<Integer, MenuState> map;

        private MenuState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MenuState valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, MenuState>();
            for (MenuState state : MenuState.values()) {
                map.put(state.getValue(), state);
            }
        }
    }

    private static enum ButtonAction {
        ATTACK(0),
        DEFEND(1),
        ITEM(2),
        FLEE(3),
        ATTACK_TARGET(4),
        SWITCH_HELD_ITEM(5),
        DECIDE_USE_ITEM(6),
        CANCEL(7),
        DO_ITEM_SWITCH(8),
        DO_USE_ITEM(9);

        private int value;
        private static Map<Integer, ButtonAction> map;

        private ButtonAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ButtonAction valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, ButtonAction>();
            for (ButtonAction action : ButtonAction.values()) {
                map.put(action.getValue(), action);
            }
        }
    }
}

