/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketBattleDecision
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("com_burnedkirby_turnbasedminecraft", "network_packetbattledecision");
    private int battleID;
    private Battle.Decision decision;
    private int targetIDOrItemID;

    public PacketBattleDecision() {
    }

    public PacketBattleDecision(int battleID, Battle.Decision decision, int targetIDOrItemID) {
        this.battleID = battleID;
        this.decision = decision;
        this.targetIDOrItemID = targetIDOrItemID;
    }

    public PacketBattleDecision(FriendlyByteBuf buf) {
        this.battleID = buf.readInt();
        this.decision = Battle.Decision.valueOf(buf.readInt());
        this.targetIDOrItemID = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.battleID);
        buf.writeInt(this.decision.getValue());
        buf.writeInt(this.targetIDOrItemID);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static class PayloadHandler {
        private static final PayloadHandler INSTANCE = new PayloadHandler();

        public static PayloadHandler getInstance() {
            return INSTANCE;
        }

        public void handleData(PacketBattleDecision pkt, PlayPayloadContext ctx) {
            ctx.workHandler().submitAsync(() -> {
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(pkt.battleID);
                if (b != null) {
                    Player player = (Player)ctx.player().get();
                    b.setDecision(player.getId(), pkt.decision, pkt.targetIDOrItemID);
                }
            }).exceptionally(e -> {
                ctx.packetHandler().disconnect((Component)Component.literal((String)("Exception handling PacketBattleDecision! " + e.getMessage())));
                return null;
            });
        }
    }
}

