/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.damagesource.DamageType;
import org.apache.logging.log4j.Logger;

public class Config {
    public static final long BATTLE_DECISION_DURATION_SEC_MIN = 5L;
    public static final long BATTLE_DECISION_DURATION_SEC_MAX = 60L;
    public static final long BATTLE_DECISION_DURATION_SEC_DEFAULT = 15L;
    public static final long BATTLE_DECISION_DURATION_NANO_MIN = 5000000000L;
    public static final long BATTLE_DECISION_DURATION_NANO_MAX = 60000000000L;
    public static final long BATTLE_DECISION_DURATION_NANO_DEFAULT = 15000000000L;
    private long battleDecisionDurationNanos = 15000000000L;
    private boolean battleDecisionDurationForever = false;
    private Map<String, EntityInfo> entityInfoMap = new HashMap<String, EntityInfo>();
    private Map<String, EntityInfo> customEntityInfoMap = new HashMap<String, EntityInfo>();
    private Set<String> ignoreBattleTypes = new HashSet<String>();
    private Logger logger;
    private int playerSpeed = 50;
    private int playerHasteSpeed = 80;
    private int playerSlowSpeed = 20;
    private int playerAttackProbability = 100;
    private int playerEvasion = 10;
    private int defenseDuration = 1;
    private int fleeGoodProbability = 90;
    private int fleeBadProbability = 35;
    private int minimumHitPercentage = 4;
    private int maxInBattle = 8;
    private Set<String> musicBattleTypes;
    private Set<String> musicSillyTypes;
    private boolean freezeCombatantsInBattle = false;
    private int sillyMusicThreshold = 40;
    private int configVersion = 0;
    private Set<Integer> battleIgnoringPlayers = null;
    private boolean onlyOPsSelfDisableTB = true;
    private boolean battleDisabledForAll = false;
    private boolean oldBattleBehaviorEnabled = false;
    private int leaveBattleCooldownSeconds = 5;
    private int aggroStartBattleDistance = 8;
    private int creeperExplodeTurn = 5;
    private boolean creeperStopExplodeOnLeaveBattle = true;
    private boolean creeperAlwaysAllowDamage = true;
    private Set<String> possibleIgnoreHurtDamageSources;
    private Set<String> ignoreHurtDamageSources;
    private boolean playerOnlyBattles = false;

    public Config(Logger logger) {
        this.logger = logger;
        this.musicBattleTypes = new HashSet<String>();
        this.musicSillyTypes = new HashSet<String>();
        this.battleIgnoringPlayers = new HashSet<Integer>();
        this.possibleIgnoreHurtDamageSources = new HashSet<String>();
        this.ignoreHurtDamageSources = new HashSet<String>();
        this.loadDamageSources();
        File confPath = new File("config/TurnBasedMinecraft/");
        if (!confPath.exists() && !confPath.mkdirs()) {
            logger.error("Failed to create config dir \"config/TurnBasedMinecraft/\"");
            return;
        }
        this.writeDefaultConfig(this.getClass().getResourceAsStream("/assets/com_burnedkirby_turnbasedminecraft/TBM_Config.toml"));
        int internalVersion = this.getConfigFileVersion(new File("config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml"));
        if (internalVersion == 0) {
            logger.error("Failed to check version of internal config file");
            logger.error("Tried path \"config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml\"");
        } else {
            this.configVersion = internalVersion;
        }
        try {
            File testLoad = new File("config/TurnBasedMinecraft/TBM_Config.toml");
            if (!testLoad.exists()) {
                this.writeConfig();
            }
        }
        catch (Throwable t) {
            logger.error("Failed to check/create-new config file");
        }
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        if (!configFile.exists() || !configFile.canRead()) {
            logger.error("Failed to read/parse config file config/TurnBasedMinecraft/TBM_Config.toml");
            return;
        }
        int configVersion = this.getConfigFileVersion(configFile);
        boolean canOverwrite = this.getCanOverwrite(configFile);
        if (configVersion < this.configVersion && canOverwrite) {
            logger.warn("Config file TBM_Config.toml is older version, renaming...");
            this.moveOldConfig();
            try {
                this.writeConfig();
            }
            catch (Throwable t) {
                logger.error("Failed to write config file!");
            }
        }
        try {
            this.parseConfig(configFile);
        }
        catch (Throwable t) {
            logger.error("Failed to parse config file!");
        }
    }

    private void writeConfig() throws IOException {
        int read;
        InputStream is = this.getClass().getResourceAsStream("/assets/com_burnedkirby_turnbasedminecraft/TBM_Config.toml");
        FileOutputStream fos = new FileOutputStream("config/TurnBasedMinecraft/TBM_Config.toml");
        byte[] buf = new byte[1024];
        while ((read = is.read(buf)) > 0) {
            fos.write(buf, 0, read);
        }
        fos.close();
        is.close();
    }

    private void moveOldConfig() {
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        if (configFile.exists()) {
            configFile.renameTo(new File("config/TurnBasedMinecraft/TBM_Config_" + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + ".toml"));
        }
    }

    private boolean parseConfig(File configFile) throws IOException {
        CommentedFileConfig conf = this.getConfigObj(configFile);
        try {
            Collection battle_music_categories = (Collection)conf.get("client_config.battle_music");
            if (battle_music_categories != null) {
                for (String category : battle_music_categories) {
                    this.musicBattleTypes.add(category);
                }
            } else {
                this.musicBattleTypes.add("monster");
                this.musicBattleTypes.add("animal");
                this.musicBattleTypes.add("boss");
                this.musicBattleTypes.add("player");
                this.logNotFound("client_config.battle_music");
            }
        }
        catch (ClassCastException e) {
            this.musicBattleTypes.add("monster");
            this.musicBattleTypes.add("animal");
            this.musicBattleTypes.add("boss");
            this.musicBattleTypes.add("player");
            this.logTOMLInvalidValue("client_config.battle_music");
        }
        try {
            Collection silly_music_categories = (Collection)conf.get("client_config.silly_music");
            if (silly_music_categories != null) {
                for (String category : silly_music_categories) {
                    this.musicSillyTypes.add(category);
                }
            } else {
                this.musicSillyTypes.add("passive");
                this.logNotFound("client_config.silly_music");
            }
        }
        catch (ClassCastException e) {
            this.musicSillyTypes.add("passive");
            this.logTOMLInvalidValue("client_config.silly_music");
        }
        try {
            OptionalInt silly_music_threshold = conf.getOptionalInt("client_config.silly_music_threshold");
            if (silly_music_threshold.isPresent()) {
                this.sillyMusicThreshold = silly_music_threshold.getAsInt();
            } else {
                this.sillyMusicThreshold = 40;
                this.logNotFound("client_config.silly_music_threshold", "40");
            }
        }
        catch (ClassCastException e) {
            this.sillyMusicThreshold = 40;
            this.logTOMLInvalidValue("client_config.silly_music_threshold", "40");
        }
        try {
            OptionalInt leave_battle_cooldown = conf.getOptionalInt("server_config.leave_battle_cooldown");
            if (leave_battle_cooldown.isPresent()) {
                this.leaveBattleCooldownSeconds = leave_battle_cooldown.getAsInt();
                if (this.leaveBattleCooldownSeconds < 1) {
                    this.logClampedValue("server_config.leave_battle_cooldown", Integer.toString(this.leaveBattleCooldownSeconds), "1");
                    this.leaveBattleCooldownSeconds = 1;
                } else if (this.leaveBattleCooldownSeconds > 10) {
                    this.logClampedValue("server_config.leave_battle_cooldown", Integer.toString(this.leaveBattleCooldownSeconds), "10");
                    this.leaveBattleCooldownSeconds = 10;
                }
            } else {
                this.leaveBattleCooldownSeconds = 5;
                this.logNotFound("server_config.leave_battle_cooldown", "5");
            }
        }
        catch (ClassCastException e) {
            this.leaveBattleCooldownSeconds = 5;
            this.logTOMLInvalidValue("server_config.leave_battle_cooldown", "5");
        }
        try {
            OptionalInt aggro_start_battle_max_distance = conf.getOptionalInt("server_config.aggro_start_battle_max_distance");
            if (aggro_start_battle_max_distance.isPresent()) {
                this.aggroStartBattleDistance = aggro_start_battle_max_distance.getAsInt();
                if (this.aggroStartBattleDistance < 5) {
                    this.logClampedValue("server_config.aggro_start_battle_max_distance", Integer.toString(this.aggroStartBattleDistance), "5");
                    this.aggroStartBattleDistance = 5;
                } else if (this.aggroStartBattleDistance > 50) {
                    this.logClampedValue("server_config.aggro_start_battle_max_distance", Integer.toString(this.aggroStartBattleDistance), "50");
                    this.aggroStartBattleDistance = 50;
                }
            } else {
                this.aggroStartBattleDistance = 8;
                this.logNotFound("server_config.aggro_start_battle_max_distance", "8");
            }
        }
        catch (ClassCastException e) {
            this.aggroStartBattleDistance = 8;
            this.logTOMLInvalidValue("server_config.aggro_start_battle_max_distance", "8");
        }
        try {
            OptionalInt creeper_explode_turn = conf.getOptionalInt("server_config.creeper_explode_turn");
            if (creeper_explode_turn.isPresent()) {
                this.creeperExplodeTurn = creeper_explode_turn.getAsInt();
                if (this.creeperExplodeTurn < 1) {
                    this.logClampedValue("server_config.creeper_explode_turn", Integer.toString(this.creeperExplodeTurn), "1");
                    this.creeperExplodeTurn = 1;
                }
            } else {
                this.creeperExplodeTurn = 5;
                this.logNotFound("server_config.creeper_explode_turn", "5");
            }
        }
        catch (ClassCastException e) {
            this.creeperExplodeTurn = 5;
            this.logTOMLInvalidValue("server_config.creeper_explode_turn", "5");
        }
        try {
            Boolean creeper_stop_explode_on_leave_battle = (Boolean)conf.get("server_config.creeper_stop_explode_on_leave_battle");
            if (creeper_stop_explode_on_leave_battle != null) {
                this.creeperStopExplodeOnLeaveBattle = creeper_stop_explode_on_leave_battle;
            } else {
                this.creeperStopExplodeOnLeaveBattle = true;
                this.logNotFound("server_config.creeper_stop_explode_on_leave_battle", "true");
            }
        }
        catch (ClassCastException e) {
            this.creeperStopExplodeOnLeaveBattle = true;
            this.logTOMLInvalidValue("server_config.creeper_stop_explode_on_leave_battle", "true");
        }
        try {
            Boolean creeper_always_allow_damage = (Boolean)conf.get("server_config.creeper_always_allow_damage");
            if (creeper_always_allow_damage != null) {
                this.creeperAlwaysAllowDamage = creeper_always_allow_damage;
            } else {
                this.creeperAlwaysAllowDamage = true;
                this.logNotFound("server_config.creeper_always_allow_damage", "true");
            }
        }
        catch (ClassCastException e) {
            this.creeperAlwaysAllowDamage = true;
            this.logTOMLInvalidValue("server_config.creeper_always_allow_damage", "true");
        }
        try {
            Boolean old_battle_behavior = (Boolean)conf.get("server_config.old_battle_behavior");
            if (old_battle_behavior != null) {
                this.oldBattleBehaviorEnabled = old_battle_behavior;
            } else {
                this.oldBattleBehaviorEnabled = false;
                this.logNotFound("server_config.old_battle_behavior", "false");
            }
        }
        catch (ClassCastException e) {
            this.oldBattleBehaviorEnabled = false;
            this.logTOMLInvalidValue("server_config.old_battle_behavior", "false");
        }
        try {
            Boolean anyone_can_disable_tbm_for_self = (Boolean)conf.get("server_config.anyone_can_disable_tbm_for_self");
            if (anyone_can_disable_tbm_for_self != null) {
                this.onlyOPsSelfDisableTB = anyone_can_disable_tbm_for_self == false;
            } else {
                this.onlyOPsSelfDisableTB = true;
                this.logNotFound("server_config.anyone_can_disable_tbm_for_self", "false");
            }
        }
        catch (ClassCastException e) {
            this.onlyOPsSelfDisableTB = true;
            this.logTOMLInvalidValue("server_config.anyone_can_disable_tbm_for_self", "false");
        }
        try {
            OptionalInt max_in_battle = conf.getOptionalInt("server_config.max_in_battle");
            if (max_in_battle.isPresent()) {
                this.maxInBattle = max_in_battle.getAsInt();
                if (this.maxInBattle < 2) {
                    this.logClampedValue("server_config.max_in_battle", Integer.toString(this.maxInBattle), "2");
                    this.maxInBattle = 2;
                }
            } else {
                this.maxInBattle = 8;
                this.logNotFound("server_config.max_in_battle", "8");
            }
        }
        catch (ClassCastException e) {
            this.maxInBattle = 8;
            this.logTOMLInvalidValue("server_config.max_in_battle", "8");
        }
        try {
            Boolean freeze_battle_combatants = (Boolean)conf.get("server_config.freeze_battle_combatants");
            if (freeze_battle_combatants != null) {
                this.freezeCombatantsInBattle = freeze_battle_combatants;
            } else {
                this.freezeCombatantsInBattle = false;
                this.logNotFound("server_config.freeze_battle_combatants", "false");
            }
        }
        catch (ClassCastException e) {
            this.freezeCombatantsInBattle = false;
            this.logTOMLInvalidValue("server_config.freeze_battle_combatants", "false");
        }
        try {
            Collection ignore_battle_types = (Collection)conf.get("server_config.ignore_battle_types");
            if (ignore_battle_types != null) {
                this.ignoreBattleTypes.addAll(ignore_battle_types);
            } else {
                this.ignoreBattleTypes.add("passive");
                this.ignoreBattleTypes.add("boss");
                this.logNotFound("server_config.ignore_battle_types");
            }
        }
        catch (ClassCastException e) {
            this.ignoreBattleTypes.add("passive");
            this.ignoreBattleTypes.add("boss");
            this.logTOMLInvalidValue("server_config.ignore_battle_types");
        }
        try {
            OptionalInt player_speed = conf.getOptionalInt("server_config.player_speed");
            if (player_speed.isPresent()) {
                this.playerSpeed = player_speed.getAsInt();
            } else {
                this.playerSpeed = 50;
                this.logNotFound("server_config.player_speed", "50");
            }
        }
        catch (ClassCastException e) {
            this.playerSpeed = 50;
            this.logTOMLInvalidValue("server_config.player_speed", "50");
        }
        try {
            OptionalInt player_haste_speed = conf.getOptionalInt("server_config.player_haste_speed");
            if (player_haste_speed.isPresent()) {
                this.playerHasteSpeed = player_haste_speed.getAsInt();
            } else {
                this.playerHasteSpeed = 80;
                this.logNotFound("server_config.player_haste_speed", "80");
            }
        }
        catch (ClassCastException e) {
            this.playerHasteSpeed = 80;
            this.logTOMLInvalidValue("server_config.player_haste_speed", "80");
        }
        try {
            OptionalInt player_slow_speed = conf.getOptionalInt("server_config.player_slow_speed");
            if (player_slow_speed.isPresent()) {
                this.playerSlowSpeed = player_slow_speed.getAsInt();
            } else {
                this.playerSlowSpeed = 20;
                this.logNotFound("server_config.player_slow_speed", "20");
            }
        }
        catch (ClassCastException e) {
            this.playerSlowSpeed = 20;
            this.logTOMLInvalidValue("server_config.player_slow_speed", "20");
        }
        try {
            OptionalInt player_attack_probability = conf.getOptionalInt("server_config.player_attack_probability");
            if (player_attack_probability.isPresent()) {
                this.playerAttackProbability = player_attack_probability.getAsInt();
            } else {
                this.playerAttackProbability = 90;
                this.logNotFound("server_config.player_attack_probability", "90");
            }
        }
        catch (ClassCastException e) {
            this.playerAttackProbability = 90;
            this.logTOMLInvalidValue("server_config.player_attack_probability", "90");
        }
        try {
            OptionalInt player_evasion = conf.getOptionalInt("server_config.player_evasion");
            if (player_evasion.isPresent()) {
                this.playerEvasion = player_evasion.getAsInt();
            } else {
                this.playerEvasion = 10;
                this.logNotFound("server_config.player_evasion", "10");
            }
        }
        catch (ClassCastException e) {
            this.playerEvasion = 10;
            this.logTOMLInvalidValue("server_config.player_evasion", "10");
        }
        try {
            OptionalInt defense_duration = conf.getOptionalInt("server_config.defense_duration");
            if (defense_duration.isPresent()) {
                this.defenseDuration = defense_duration.getAsInt();
                if (this.defenseDuration < 0) {
                    this.logClampedValue("server_config.defense_duration", Integer.toString(this.defenseDuration), "0");
                    this.defenseDuration = 0;
                }
            } else {
                this.defenseDuration = 1;
                this.logNotFound("server_config.defense_duration", "1");
            }
        }
        catch (ClassCastException e) {
            this.defenseDuration = 1;
            this.logTOMLInvalidValue("server_config.defense_duration", "1");
        }
        try {
            OptionalInt flee_good_probability = conf.getOptionalInt("server_config.flee_good_probability");
            if (flee_good_probability.isPresent()) {
                this.fleeGoodProbability = flee_good_probability.getAsInt();
            } else {
                this.fleeGoodProbability = 90;
                this.logNotFound("server_config.flee_good_probability", "90");
            }
        }
        catch (ClassCastException e) {
            this.fleeGoodProbability = 90;
            this.logTOMLInvalidValue("server_config.flee_good_probability", "90");
        }
        try {
            OptionalInt flee_bad_probability = conf.getOptionalInt("server_config.flee_bad_probability");
            if (flee_bad_probability.isPresent()) {
                this.fleeBadProbability = flee_bad_probability.getAsInt();
            } else {
                this.fleeBadProbability = 35;
                this.logNotFound("server_config.flee_bad_probability", "35");
            }
        }
        catch (ClassCastException e) {
            this.fleeBadProbability = 35;
            this.logTOMLInvalidValue("server_config.flee_bad_probability", "35");
        }
        try {
            OptionalInt minimum_hit_percentage = conf.getOptionalInt("server_config.minimum_hit_percentage");
            if (minimum_hit_percentage.isPresent()) {
                this.minimumHitPercentage = minimum_hit_percentage.getAsInt();
                if (this.minimumHitPercentage < 1) {
                    this.logClampedValue("server_config.minimum_hit_percentage", Integer.toString(this.minimumHitPercentage), "1");
                    this.minimumHitPercentage = 1;
                }
            } else {
                this.minimumHitPercentage = 4;
                this.logNotFound("server_config.minimum_hit_percentage", "4");
            }
        }
        catch (ClassCastException e) {
            this.minimumHitPercentage = 4;
            this.logTOMLInvalidValue("server_config.minimum_hit_percentage", "4");
        }
        try {
            OptionalInt battle_turn_time_seconds = conf.getOptionalInt("server_config.battle_turn_time_seconds");
            if (battle_turn_time_seconds.isPresent()) {
                this.battleDecisionDurationNanos = (long)battle_turn_time_seconds.getAsInt() * 1000000000L;
                if (this.battleDecisionDurationNanos < 5000000000L) {
                    this.battleDecisionDurationNanos = 5000000000L;
                    this.logClampedValue("server_config.battle_turn_time_seconds", Integer.toString(battle_turn_time_seconds.getAsInt()), Long.toString(5L));
                } else if (this.battleDecisionDurationNanos > 60000000000L) {
                    this.battleDecisionDurationNanos = 60000000000L;
                    this.logClampedValue("server_config.battle_turn_time_seconds", Integer.toString(battle_turn_time_seconds.getAsInt()), Long.toString(60L));
                }
            } else {
                this.battleDecisionDurationNanos = 15000000000L;
                this.logNotFound("server_config.battle_turn_time_seconds", "15");
            }
        }
        catch (ClassCastException e) {
            this.battleDecisionDurationNanos = 15000000000L;
            this.logTOMLInvalidValue("server_config.battle_turn_time_seconds", "15");
        }
        try {
            Boolean battle_turn_wait_forever = (Boolean)conf.get("server_config.battle_turn_wait_forever");
            if (battle_turn_wait_forever != null) {
                this.battleDecisionDurationForever = battle_turn_wait_forever;
            } else {
                this.battleDecisionDurationForever = false;
                this.logNotFound("server_config.battle_turn_wait_forever", "false");
            }
        }
        catch (ClassCastException e) {
            this.battleDecisionDurationForever = false;
            this.logTOMLInvalidValue("server_config.battle_turn_wait_forever", "false");
        }
        try {
            Collection damage_sources = (Collection)conf.get("server_config.ignore_damage_sources");
            for (String source : damage_sources) {
                if (!this.possibleIgnoreHurtDamageSources.contains(source)) continue;
                this.ignoreHurtDamageSources.add(source);
            }
        }
        catch (ClassCastException e) {
            this.logTOMLInvalidValue("server_config.ignore_damage_sources");
        }
        try {
            Boolean is_only_player_battles_enabled = (Boolean)conf.get("server_config.player_only_battles");
            if (is_only_player_battles_enabled != null) {
                this.playerOnlyBattles = is_only_player_battles_enabled;
            } else {
                this.playerOnlyBattles = false;
                this.logNotFound("server_config.player_only_battles", "false");
            }
        }
        catch (ClassCastException e) {
            this.playerOnlyBattles = false;
            this.logTOMLInvalidValue("server_config.player_only_battles", "false");
        }
        Collection entities = null;
        try {
            entities = (Collection)conf.get("server_config.entity");
        }
        catch (ClassCastException e) {
            this.logTOMLInvalidValue("server_config.entity");
        }
        if (entities != null) {
            for (com.electronwill.nightconfig.core.Config nestedConf : entities) {
                String name;
                EntityInfo eInfo;
                block199: {
                    block198: {
                        block197: {
                            eInfo = new EntityInfo();
                            if (nestedConf.contains("name") && nestedConf.contains("custom_name")) {
                                this.logger.error("Entity cannot have both \"name\" (" + nestedConf.get("name") + ") and \"custom_name\" (" + nestedConf.get("custom_name") + ") entries");
                                continue;
                            }
                            if (nestedConf.contains("name")) {
                                try {
                                    eInfo.classType = Class.forName((String)nestedConf.get("name"));
                                    name = eInfo.classType.getName();
                                    break block197;
                                }
                                catch (ClassNotFoundException e) {
                                    this.logger.error("Entity with class name \"" + nestedConf.get("name") + "\" not found, skipping...");
                                    continue;
                                }
                            }
                            if (nestedConf.contains("custom_name")) {
                                try {
                                    name = eInfo.customName = (String)nestedConf.get("custom_name");
                                    break block197;
                                }
                                catch (ClassCastException e) {
                                    this.logger.error("Entity with invalid custom_name (must be a string), skipping...");
                                    continue;
                                }
                            }
                            this.logger.error("Entity must have \"name\" or \"custom_name\" entry");
                            continue;
                        }
                        try {
                            eInfo.attackPower = nestedConf.getInt("attack_power");
                            if (eInfo.attackPower < 0) {
                                this.logClampedValueEntity("attack_power", name, Integer.toString(eInfo.attackPower), "0");
                                eInfo.attackPower = 0;
                            }
                        }
                        catch (ClassCastException e) {
                            this.logEntityInvalidValue("attack_power", name, "3");
                            eInfo.attackPower = 3;
                        }
                        catch (NullPointerException e) {
                            this.logEntityMissingRequiredValue("attack_power", name, "3");
                            eInfo.attackPower = 3;
                        }
                        try {
                            eInfo.attackProbability = nestedConf.getInt("attack_probability");
                            if (eInfo.attackProbability < 0) {
                                this.logClampedValueEntity("attack_probability", name, Integer.toString(eInfo.attackProbability), "0");
                                eInfo.attackProbability = 0;
                            } else if (eInfo.attackProbability > 100) {
                                this.logClampedValueEntity("attack_probability", name, Integer.toString(eInfo.attackProbability), "100");
                                eInfo.attackProbability = 100;
                            }
                        }
                        catch (ClassCastException e) {
                            this.logEntityInvalidValue("attack_probability", name, "30");
                            eInfo.attackProbability = 30;
                        }
                        catch (NullPointerException e) {
                            this.logEntityMissingRequiredValue("attack_probability", name, "30");
                            eInfo.attackProbability = 30;
                        }
                        try {
                            eInfo.attackEffect = EntityInfo.Effect.fromString((String)nestedConf.get("attack_effect"));
                            if (eInfo.attackEffect == EntityInfo.Effect.UNKNOWN) break block198;
                            try {
                                eInfo.attackEffectProbability = nestedConf.getInt("attack_effect_probability");
                                if (eInfo.attackEffectProbability < 0) {
                                    this.logClampedValueEntity("attack_effect_probability", name, Integer.toString(eInfo.attackEffectProbability), "1");
                                    eInfo.attackEffectProbability = 1;
                                } else if (eInfo.attackEffectProbability > 100) {
                                    this.logClampedValueEntity("attack_effect_probability", name, Integer.toString(eInfo.attackEffectProbability), "100");
                                    eInfo.attackEffectProbability = 100;
                                }
                            }
                            catch (ClassCastException e) {
                                eInfo.attackEffect = EntityInfo.Effect.UNKNOWN;
                                this.logger.warn("Entity \"" + name + "\" has specified attack_effect but attack_effect_probability is invalid, unsetting attack_effect");
                            }
                            catch (NullPointerException e) {
                                eInfo.attackEffect = EntityInfo.Effect.UNKNOWN;
                                this.logger.warn("Entity \"" + name + "\" has specified attack_effect but attack_effect_probability is missing, unsetting attack_effect");
                            }
                        }
                        catch (ClassCastException e) {
                            eInfo.attackEffect = EntityInfo.Effect.UNKNOWN;
                            this.logEntityInvalidValue("attack_effect", name, "unknown");
                        }
                        catch (NullPointerException e) {
                            eInfo.attackEffect = EntityInfo.Effect.UNKNOWN;
                            this.logEntityMissingOptionalValue("attack_effect", name, "unknown");
                        }
                    }
                    try {
                        eInfo.attackVariance = nestedConf.getInt("attack_variance");
                        if (eInfo.attackVariance < 0) {
                            this.logClampedValueEntity("attack_variance", name, Integer.toString(eInfo.attackVariance), "0");
                            eInfo.attackVariance = 0;
                        }
                    }
                    catch (ClassCastException e) {
                        eInfo.attackVariance = 0;
                        this.logEntityInvalidValue("attack_variance", name, "0");
                    }
                    catch (NullPointerException e) {
                        eInfo.attackVariance = 0;
                        this.logEntityMissingOptionalValue("attack_variance", name, "0");
                    }
                    try {
                        eInfo.defenseDamage = nestedConf.getInt("defense_damage");
                        if (eInfo.defenseDamage < 0) {
                            this.logClampedValueEntity("defense_damage", name, Integer.toString(eInfo.defenseDamage), "0");
                            eInfo.defenseDamage = 0;
                            break block199;
                        }
                        if (eInfo.defenseDamage == 0) break block199;
                        try {
                            eInfo.defenseDamageProbability = nestedConf.getInt("defense_damage_probability");
                            if (eInfo.defenseDamageProbability < 1) {
                                this.logClampedValueEntity("defense_damage_probability", name, Integer.toString(eInfo.defenseDamageProbability), "1");
                                eInfo.defenseDamageProbability = 1;
                            } else if (eInfo.defenseDamageProbability > 100) {
                                this.logClampedValueEntity("defense_damage_probability", name, Integer.toString(eInfo.defenseDamageProbability), "100");
                                eInfo.defenseDamageProbability = 100;
                            }
                        }
                        catch (ClassCastException e) {
                            eInfo.defenseDamage = 0;
                            this.logger.warn("Entity \"" + name + "\" has specified defense_damage but defense_damage_probability is invalid, disabling defense_damage");
                        }
                        catch (NullPointerException e) {
                            eInfo.defenseDamage = 0;
                            this.logger.warn("Entity \"" + name + "\" has specified defense_damage but defense_damage_probability is missing, disabling defense_damage");
                        }
                    }
                    catch (ClassCastException e) {
                        eInfo.defenseDamage = 0;
                        this.logEntityInvalidValue("defense_damage", name, "0");
                    }
                    catch (NullPointerException e) {
                        eInfo.defenseDamage = 0;
                        this.logEntityMissingOptionalValue("defense_damage", name, "0");
                    }
                }
                try {
                    eInfo.evasion = nestedConf.getInt("evasion");
                    if (eInfo.evasion < 0) {
                        this.logClampedValueEntity("evasion", name, Integer.toString(eInfo.evasion), "0");
                        eInfo.evasion = 0;
                    } else if (eInfo.evasion > 100) {
                        this.logClampedValueEntity("evasion", name, Integer.toString(eInfo.evasion), "100");
                        eInfo.evasion = 100;
                    }
                }
                catch (ClassCastException e) {
                    this.logEntityInvalidValue("evasion", name, "7");
                    eInfo.evasion = 7;
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("evasion", name, "7");
                    eInfo.evasion = 7;
                }
                try {
                    eInfo.speed = nestedConf.getInt("speed");
                }
                catch (ClassCastException e) {
                    this.logEntityInvalidValue("speed", name, "49");
                    eInfo.speed = 49;
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("speed", name, "49");
                    eInfo.speed = 49;
                }
                try {
                    eInfo.ignoreBattle = (Boolean)nestedConf.get("ignore_battle");
                }
                catch (ClassCastException e) {
                    this.logEntityInvalidValue("ignore_battle", name, "false");
                    eInfo.ignoreBattle = false;
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("ignore_battle", name, "false");
                    eInfo.ignoreBattle = false;
                }
                try {
                    eInfo.category = (String)nestedConf.get("category");
                }
                catch (ClassCastException e) {
                    this.logEntityInvalidValue("category", name, "unknown");
                    eInfo.category = "unknown";
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("category", name, "unknown");
                    eInfo.category = "unknown";
                }
                try {
                    eInfo.decisionAttack = nestedConf.getInt("decision_attack_probability");
                    if (eInfo.decisionAttack < 0) {
                        this.logClampedValueEntity("decision_attack_probability", name, Integer.toString(eInfo.decisionAttack), "0");
                        eInfo.decisionAttack = 0;
                    } else if (eInfo.decisionAttack > 100) {
                        this.logClampedValueEntity("decision_attack_probability", name, Integer.toString(eInfo.decisionAttack), "100");
                        eInfo.decisionAttack = 100;
                    }
                }
                catch (ClassCastException e) {
                    this.logEntityInvalidValue("decision_attack_probability", name, "70");
                    eInfo.decisionAttack = 70;
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("decision_attack_probability", name, "70");
                    eInfo.decisionAttack = 70;
                }
                try {
                    eInfo.decisionDefend = nestedConf.getInt("decision_defend_probability");
                    if (eInfo.decisionDefend < 0) {
                        this.logClampedValueEntity("decision_defend_probability", name, Integer.toString(eInfo.decisionDefend), "0");
                        eInfo.decisionDefend = 0;
                    } else if (eInfo.decisionDefend > 100) {
                        this.logClampedValueEntity("decision_defend_probability", name, Integer.toString(eInfo.decisionDefend), "100");
                        eInfo.decisionDefend = 100;
                    }
                }
                catch (ClassCastException e) {
                    this.logEntityInvalidValue("decision_defend_probability", name, "20");
                    eInfo.decisionDefend = 20;
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("decision_defend_probability", name, "20");
                    eInfo.decisionDefend = 20;
                }
                try {
                    eInfo.decisionFlee = nestedConf.getInt("decision_flee_probability");
                    if (eInfo.decisionFlee < 0) {
                        this.logClampedValueEntity("decision_flee_probability", name, Integer.toString(eInfo.decisionFlee), "0");
                        eInfo.decisionFlee = 0;
                    } else if (eInfo.decisionFlee > 100) {
                        this.logClampedValueEntity("decision_flee_probability", name, Integer.toString(eInfo.decisionFlee), "100");
                        eInfo.decisionFlee = 100;
                    }
                }
                catch (ClassCastException e) {
                    this.logEntityInvalidValue("decision_flee_probability", name, "10");
                    eInfo.decisionFlee = 10;
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("decision_flee_probability", name, "10");
                    eInfo.decisionFlee = 10;
                }
                if (eInfo.classType != null) {
                    this.entityInfoMap.put(eInfo.classType.getName(), eInfo);
                    continue;
                }
                if (!eInfo.customName.isEmpty()) {
                    this.customEntityInfoMap.put(eInfo.customName, eInfo);
                    continue;
                }
                this.logger.error("Cannot add entity to internal config, no \"name\" or \"custom_name\"");
            }
        }
        return true;
    }

    private void logNotFound(String option) {
        this.logger.warn("Config option \"" + option + "\" not found, setting defaults");
    }

    private void logNotFound(String option, String defaultValue) {
        this.logger.warn("Config option \"" + option + "\" not found, defaulting to \"" + defaultValue + "\"");
    }

    private void logEntityInvalidValue(String option, String name, String defaultValue) {
        this.logger.warn("Invalid \"" + option + "\" for \"" + name + "\", defaulting to \"" + defaultValue + "\"");
    }

    private void logEntityMissingRequiredValue(String option, String name, String defaultValue) {
        this.logger.warn("Entity \"" + name + "\" does not have option \"" + option + "\", defaulting to \"" + defaultValue + "\"");
    }

    private void logEntityMissingOptionalValue(String option, String name, String defaultValue) {
        this.logger.info("Entity \"" + name + "\" does not have optional option \"" + option + "\", defaulting to \"" + defaultValue + "\"...");
    }

    private void logClampedValue(String option, String from, String clampedTo) {
        this.logger.warn("Option \"" + option + "\" is out of bounds, clamping value from \"" + from + "\" to \"" + clampedTo + "\"");
    }

    private void logClampedValueEntity(String option, String name, String from, String clampedTo) {
        this.logger.warn("Option \"" + option + "\" is out of bounds for \"" + name + "\", clamping value from \"" + from + "\" to \"" + clampedTo + "\"");
    }

    private void logTOMLInvalidValue(String option) {
        this.logger.warn("Config option \"" + option + "\" is an invalid value, setting defaults");
    }

    private void logTOMLInvalidValue(String option, String defaultValue) {
        this.logger.warn("Config option \"" + option + "\" is an invalid value, defaulting to \"" + defaultValue + "\"");
    }

    private boolean addEntityEntry(EntityInfo eInfo) {
        Collection entities;
        CommentedFileConfig conf = (CommentedFileConfig)CommentedFileConfig.builder((String)"config/TurnBasedMinecraft/TBM_Config.toml").build();
        conf.load();
        try {
            entities = (Collection)conf.get("server_config.entity");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        CommentedConfig newConf = conf.createSubConfig();
        newConf.set("attack_power", (Object)eInfo.attackPower);
        newConf.set("attack_probability", (Object)eInfo.attackProbability);
        newConf.set("attack_variance", (Object)eInfo.attackVariance);
        newConf.set("attack_effect", (Object)eInfo.attackEffect.toString());
        newConf.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
        newConf.set("defense_damage", (Object)eInfo.defenseDamage);
        newConf.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
        newConf.set("evasion", (Object)eInfo.evasion);
        newConf.set("speed", (Object)eInfo.speed);
        newConf.set("ignore_battle", (Object)eInfo.ignoreBattle);
        newConf.set("category", (Object)eInfo.category);
        newConf.set("decision_attack_probability", (Object)eInfo.decisionAttack);
        newConf.set("decision_defend_probability", (Object)eInfo.decisionDefend);
        newConf.set("decision_flee_probability", (Object)eInfo.decisionFlee);
        entities.add(newConf);
        conf.save();
        conf.close();
        return true;
    }

    protected boolean editEntityEntry(EntityInfo eInfo) {
        boolean saved;
        CommentedFileConfig conf;
        block18: {
            Collection entities;
            conf = (CommentedFileConfig)CommentedFileConfig.builder((String)"config/TurnBasedMinecraft/TBM_Config.toml").build();
            conf.load();
            try {
                entities = (Collection)conf.get("server_config.entity");
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
            saved = false;
            try {
                if (eInfo.classType != null || !eInfo.customName.isEmpty()) {
                    for (com.electronwill.nightconfig.core.Config entity : entities) {
                        String entityName = (String)entity.get("name");
                        if (eInfo.classType != null && entityName != null && entityName.equals(eInfo.classType.getName())) {
                            entity.set("attack_power", (Object)eInfo.attackPower);
                            entity.set("attack_probability", (Object)eInfo.attackProbability);
                            entity.set("attack_variance", (Object)eInfo.attackVariance);
                            entity.set("attack_effect", (Object)eInfo.attackEffect.toString());
                            entity.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                            entity.set("defense_damage", (Object)eInfo.defenseDamage);
                            entity.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
                            entity.set("evasion", (Object)eInfo.evasion);
                            entity.set("speed", (Object)eInfo.speed);
                            entity.set("ignore_battle", (Object)eInfo.ignoreBattle);
                            entity.set("category", (Object)eInfo.category);
                            entity.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                            entity.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                            entity.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                            saved = true;
                            break;
                        }
                        String customName = (String)entity.get("custom_name");
                        if (eInfo.customName.isEmpty() || customName == null || !customName.equals(eInfo.customName)) continue;
                        entity.set("attack_power", (Object)eInfo.attackPower);
                        entity.set("attack_probability", (Object)eInfo.attackProbability);
                        entity.set("attack_variance", (Object)eInfo.attackVariance);
                        entity.set("attack_effect", (Object)eInfo.attackEffect.toString());
                        entity.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                        entity.set("defense_damage", (Object)eInfo.defenseDamage);
                        entity.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
                        entity.set("evasion", (Object)eInfo.evasion);
                        entity.set("speed", (Object)eInfo.speed);
                        entity.set("ignore_battle", (Object)eInfo.ignoreBattle);
                        entity.set("category", (Object)eInfo.category);
                        entity.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                        entity.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                        entity.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                        saved = true;
                        break;
                    }
                    if (!saved) {
                        CommentedConfig newEntry = conf.createSubConfig();
                        if (eInfo.classType != null) {
                            newEntry.set("name", (Object)eInfo.classType.getName());
                        } else if (!eInfo.customName.isEmpty()) {
                            newEntry.set("custom_name", (Object)eInfo.customName);
                        } else {
                            this.logger.error("Failed to save new entity entry into config, no name or custom_name");
                            conf.close();
                            return false;
                        }
                        newEntry.set("attack_power", (Object)eInfo.attackPower);
                        newEntry.set("attack_probability", (Object)eInfo.attackProbability);
                        newEntry.set("attack_variance", (Object)eInfo.attackVariance);
                        newEntry.set("attack_effect", (Object)eInfo.attackEffect.toString());
                        newEntry.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                        newEntry.set("defense_damage", (Object)eInfo.defenseDamage);
                        newEntry.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
                        newEntry.set("evasion", (Object)eInfo.evasion);
                        newEntry.set("speed", (Object)eInfo.speed);
                        newEntry.set("ignore_battle", (Object)eInfo.ignoreBattle);
                        newEntry.set("category", (Object)eInfo.category);
                        newEntry.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                        newEntry.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                        newEntry.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                        entities.add(newEntry);
                        saved = true;
                    }
                    break block18;
                }
                return false;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                return false;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                return false;
            }
        }
        conf.save();
        conf.close();
        if (!saved) {
            this.logger.warn("Failed to save \"" + eInfo.classType.getName() + "\"");
            return false;
        }
        if (eInfo.classType != null) {
            this.entityInfoMap.put(eInfo.classType.getName(), eInfo);
        } else if (!eInfo.customName.isEmpty()) {
            this.customEntityInfoMap.put(eInfo.customName, eInfo);
        } else {
            this.logger.warn("Failed to update entity info in memory");
        }
        return true;
    }

    public int getPlayerSpeed() {
        return this.playerSpeed;
    }

    public void setPlayerSpeed(int speed) {
        if (speed < 0) {
            speed = 0;
        } else if (speed > 100) {
            speed = 100;
        }
        this.playerSpeed = speed;
    }

    public int getPlayerHasteSpeed() {
        return this.playerHasteSpeed;
    }

    public void setPlayerHasteSpeed(int speed) {
        if (speed < 0) {
            speed = 0;
        } else if (speed > 100) {
            speed = 100;
        }
        this.playerHasteSpeed = speed;
    }

    public int getPlayerSlowSpeed() {
        return this.playerSlowSpeed;
    }

    public void setPlayerSlowSpeed(int speed) {
        if (speed < 0) {
            speed = 0;
        } else if (speed > 100) {
            speed = 100;
        }
        this.playerSlowSpeed = speed;
    }

    public int getPlayerAttackProbability() {
        return this.playerAttackProbability;
    }

    public void setPlayerAttackProbability(int probability) {
        if (probability < 1) {
            probability = 1;
        } else if (probability > 100) {
            probability = 100;
        }
        this.playerAttackProbability = probability;
    }

    public int getPlayerEvasion() {
        return this.playerEvasion;
    }

    public void setPlayerEvasion(int evasion) {
        if (evasion < 0) {
            evasion = 0;
        } else if (evasion > 100) {
            evasion = 100;
        }
        this.playerEvasion = evasion;
    }

    public int getDefenseDuration() {
        return this.defenseDuration;
    }

    public void setDefenseDuration(int turns) {
        if (turns < 0) {
            turns = 0;
        } else if (turns > 5) {
            turns = 5;
        }
        this.defenseDuration = turns;
    }

    public int getFleeGoodProbability() {
        return this.fleeGoodProbability;
    }

    public void setFleeGoodProbability(int probability) {
        if (probability < 1) {
            probability = 1;
        } else if (probability > 100) {
            probability = 100;
        }
        this.fleeGoodProbability = probability;
    }

    public int getFleeBadProbability() {
        return this.fleeBadProbability;
    }

    public void setFleeBadProbability(int probability) {
        if (probability < 1) {
            probability = 1;
        } else if (probability > 100) {
            probability = 100;
        }
        this.fleeBadProbability = probability;
    }

    public EntityInfo getEntityInfo(String classFullName) {
        if (classFullName == null) {
            return null;
        }
        EntityInfo eInfo = this.entityInfoMap.get(classFullName);
        if (eInfo != null) {
            eInfo = eInfo.clone();
        }
        return eInfo;
    }

    protected EntityInfo getEntityInfoReference(String classFullName) {
        if (classFullName == null) {
            return null;
        }
        return this.entityInfoMap.get(classFullName);
    }

    protected EntityInfo getMatchingEntityInfo(Object entity) {
        if (entity == null) {
            return null;
        }
        EntityInfo matching = this.entityInfoMap.get(entity.getClass().getName());
        if (matching != null && matching.classType.isInstance(entity)) {
            return matching;
        }
        return null;
    }

    public EntityInfo getCustomEntityInfo(String customName) {
        if (customName == null) {
            return null;
        }
        EntityInfo eInfo = this.customEntityInfoMap.get(customName);
        if (eInfo != null) {
            eInfo = eInfo.clone();
        }
        return eInfo;
    }

    protected EntityInfo getCustomEntityInfoReference(String customName) {
        if (customName == null) {
            return null;
        }
        return this.customEntityInfoMap.get(customName);
    }

    private int getConfigFileVersion(File configFile) {
        int version = 0;
        FileConfig conf = FileConfig.of((File)configFile, (ConfigFormat)TomlFormat.instance());
        conf.load();
        version = conf.getIntOrElse("version", 0);
        conf.close();
        return version;
    }

    private void writeDefaultConfig(InputStream io) {
        try {
            int count;
            FileOutputStream fos = new FileOutputStream("config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml");
            byte[] buffer = new byte[1024];
            while ((count = io.read(buffer)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            io.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean getCanOverwrite(File configFile) {
        FileConfig conf = FileConfig.of((File)configFile, (ConfigFormat)TomlFormat.instance());
        conf.load();
        boolean canOverwrite = (Boolean)conf.getOrElse("do_not_overwrite", (Object)false) == false;
        conf.close();
        return canOverwrite;
    }

    private CommentedFileConfig getConfigObj(File configFile) {
        CommentedFileConfig conf = (CommentedFileConfig)CommentedFileConfig.builder((File)configFile).defaultResource("config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml").build();
        conf.load();
        return conf;
    }

    public boolean updateConfig(String path, Object value) {
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        CommentedFileConfig conf = this.getConfigObj(configFile);
        conf.set(path, value);
        conf.save();
        conf.close();
        return true;
    }

    public boolean updateConfigAppendToStringArray(String path, String string_value) {
        Collection strings;
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        CommentedFileConfig conf = this.getConfigObj(configFile);
        try {
            strings = (Collection)conf.get(path);
        }
        catch (Exception e) {
            TurnBasedMinecraftMod.logger.warn("Exception during fetching Collection<String> from config (append)");
            TurnBasedMinecraftMod.logger.warn((Object)e);
            return false;
        }
        if (strings.contains(string_value)) {
            return false;
        }
        strings.add(string_value);
        try {
            conf.set(path, (Object)strings);
        }
        catch (Exception e) {
            TurnBasedMinecraftMod.logger.warn("Exception during setting Collection<String> in config (append)");
            TurnBasedMinecraftMod.logger.warn((Object)e);
            return false;
        }
        conf.save();
        conf.close();
        return true;
    }

    public boolean updateConfigRemoveFromStringArray(String path, String string_value) {
        Collection strings;
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        CommentedFileConfig conf = this.getConfigObj(configFile);
        try {
            strings = (Collection)conf.get(path);
        }
        catch (Exception e) {
            TurnBasedMinecraftMod.logger.warn("Exception during fetching Collection<String> from config (removal)");
            TurnBasedMinecraftMod.logger.warn((Object)e);
            return false;
        }
        if (!strings.contains(string_value)) {
            return false;
        }
        strings.remove(string_value);
        try {
            conf.set(path, (Object)strings);
        }
        catch (Exception e) {
            TurnBasedMinecraftMod.logger.warn("Exception during setting Collection<String> in config (removal)");
            TurnBasedMinecraftMod.logger.warn((Object)e);
            return false;
        }
        conf.save();
        conf.close();
        return true;
    }

    public boolean isIgnoreBattleType(String type) {
        return this.ignoreBattleTypes.contains(type);
    }

    public Collection<String> getIgnoreBattleTypes() {
        return this.ignoreBattleTypes;
    }

    public boolean removeIgnoreBattleType(String category) {
        return this.ignoreBattleTypes.remove(category);
    }

    public boolean addIgnoreBattleType(String category) {
        return this.ignoreBattleTypes.add(category);
    }

    public int getMinimumHitPercentage() {
        return this.minimumHitPercentage;
    }

    public void setMinimumHitPercentage(int percentage) {
        if (percentage < 1) {
            percentage = 1;
        } else if (percentage > 100) {
            percentage = 100;
        }
        this.minimumHitPercentage = percentage;
    }

    public int getMaxInBattle() {
        return this.maxInBattle;
    }

    public void setMaxInBattle(int maxInBattle) {
        if (maxInBattle < 2) {
            maxInBattle = 2;
        } else if (maxInBattle > 30) {
            maxInBattle = 30;
        }
        this.maxInBattle = maxInBattle;
    }

    public boolean isBattleMusicType(String type) {
        return this.musicBattleTypes.contains(type.toLowerCase());
    }

    public boolean isSillyMusicType(String type) {
        return this.musicSillyTypes.contains(type.toLowerCase());
    }

    public boolean isFreezeCombatantsEnabled() {
        return this.freezeCombatantsInBattle;
    }

    public void setFreezeCombatantsInBattle(boolean enabled) {
        this.freezeCombatantsInBattle = enabled;
    }

    public int getSillyMusicThreshold() {
        return this.sillyMusicThreshold;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public long getDecisionDurationNanos() {
        return this.battleDecisionDurationNanos;
    }

    public int getDecisionDurationSeconds() {
        return (int)(this.battleDecisionDurationNanos / 1000000000L);
    }

    public void setDecisionDurationSeconds(long seconds) {
        if (seconds < 5L) {
            seconds = 5L;
        } else if (seconds > 60L) {
            seconds = 60L;
        }
        this.battleDecisionDurationNanos = seconds * 1000000000L;
    }

    protected void addBattleIgnoringPlayer(int id) {
        this.battleIgnoringPlayers.add(id);
    }

    protected void removeBattleIgnoringPlayer(int id) {
        this.battleIgnoringPlayers.remove(id);
    }

    protected void clearBattleIgnoringPlayers() {
        this.battleIgnoringPlayers.clear();
    }

    protected Set<Integer> getBattleIgnoringPlayers() {
        return this.battleIgnoringPlayers;
    }

    public boolean getIfOnlyOPsCanDisableTurnBasedForSelf() {
        return this.onlyOPsSelfDisableTB;
    }

    public void setIfOnlyOPsCanDisableTurnBasedForSelf(boolean enabled_for_only_ops) {
        this.onlyOPsSelfDisableTB = enabled_for_only_ops;
    }

    protected void setBattleDisabledForAll(boolean isDisabled) {
        this.battleDisabledForAll = isDisabled;
    }

    protected boolean getBattleDisabledForAll() {
        return this.battleDisabledForAll;
    }

    public boolean isOldBattleBehaviorEnabled() {
        return this.oldBattleBehaviorEnabled;
    }

    public void setOldBattleBehavior(boolean enabled) {
        this.oldBattleBehaviorEnabled = enabled;
    }

    public int getLeaveBattleCooldownSeconds() {
        return this.leaveBattleCooldownSeconds;
    }

    public void setLeaveBattleCooldownSeconds(int seconds) {
        if (seconds < 1) {
            seconds = 1;
        } else if (seconds > 10) {
            seconds = 10;
        }
        this.leaveBattleCooldownSeconds = seconds;
    }

    public long getLeaveBattleCooldownNanos() {
        return (long)this.leaveBattleCooldownSeconds * 1000000000L;
    }

    public int getAggroStartBattleDistance() {
        return this.aggroStartBattleDistance;
    }

    public void setAggroStartBattleDistance(int distance) {
        if (distance < 5) {
            distance = 5;
        } else if (distance > 50) {
            distance = 50;
        }
        this.aggroStartBattleDistance = distance;
    }

    public int getCreeperExplodeTurn() {
        return this.creeperExplodeTurn;
    }

    public void setCreeperExplodeTurn(int turns) {
        if (turns < 1) {
            turns = 1;
        } else if (turns > 10) {
            turns = 10;
        }
        this.creeperExplodeTurn = turns;
    }

    public boolean getCreeperStopExplodeOnLeaveBattle() {
        return this.creeperStopExplodeOnLeaveBattle;
    }

    public void setCreeperStopExplodeOnLeaveBattle(boolean stop_explode_on_leave_battle) {
        this.creeperStopExplodeOnLeaveBattle = stop_explode_on_leave_battle;
    }

    public boolean getCreeperAlwaysAllowDamage() {
        return this.creeperAlwaysAllowDamage;
    }

    public void setCreeperAlwaysAllowDamage(boolean allow_damage) {
        this.creeperAlwaysAllowDamage = allow_damage;
    }

    public boolean isBattleDecisionDurationForever() {
        return this.battleDecisionDurationForever;
    }

    public void setBattleDecisionDurationForever(boolean battleDecisionDurationForever) {
        this.battleDecisionDurationForever = battleDecisionDurationForever;
    }

    public final Collection<String> getPossibleIgnoreHurtDamageSources() {
        return this.possibleIgnoreHurtDamageSources;
    }

    public final Collection<String> getIgnoreHurtDamageSources() {
        return this.ignoreHurtDamageSources;
    }

    public boolean addIgnoreHurtDamageSource(String source) {
        if (this.possibleIgnoreHurtDamageSources.contains(source) && !this.ignoreHurtDamageSources.contains(source)) {
            this.ignoreHurtDamageSources.add(source);
            return true;
        }
        return false;
    }

    public boolean removeIgnoreHurtDamageSource(String source) {
        return this.ignoreHurtDamageSources.remove(source);
    }

    public boolean isPlayerOnlyBattlesEnabled() {
        return this.playerOnlyBattles;
    }

    public void setIsPlayerOnlyBattles(boolean enabled) {
        this.playerOnlyBattles = enabled;
    }

    private void loadDamageSources() {
        this.possibleIgnoreHurtDamageSources.clear();
        try {
            VanillaRegistries.createLookup().lookupOrThrow(Registries.DAMAGE_TYPE).listElements().forEach(dt -> this.possibleIgnoreHurtDamageSources.add(((DamageType)dt.value()).msgId()));
        }
        catch (Exception e) {
            this.logger.warn("Config failed to load possible DamageSources! Undesired things may happen, like Zombies dying from Fire during battle!");
            this.logger.warn((Object)e);
        }
    }
}

