/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketBattleInfo
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("com_burnedkirby_turnbasedminecraft", "network_packetbattleinfo");
    private Collection<Integer> sideA;
    private Collection<Integer> sideB;
    private long decisionNanos;
    private long maxDecisionNanos;
    private boolean turnTimerEnabled;

    public PacketBattleInfo() {
        this.sideA = new ArrayList<Integer>();
        this.sideB = new ArrayList<Integer>();
        this.maxDecisionNanos = this.decisionNanos = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
        this.turnTimerEnabled = false;
    }

    public PacketBattleInfo(Collection<Integer> sideA, Collection<Integer> sideB, long decisionNanos, long maxDecisionNanos, boolean turnTimerEnabled) {
        this.sideA = sideA;
        this.sideB = sideB;
        this.decisionNanos = decisionNanos;
        this.maxDecisionNanos = maxDecisionNanos;
        this.turnTimerEnabled = turnTimerEnabled;
    }

    public PacketBattleInfo(FriendlyByteBuf buf) {
        int i;
        int sideACount = buf.readInt();
        int sideBCount = buf.readInt();
        this.sideA = new ArrayList<Integer>(sideACount);
        this.sideB = new ArrayList<Integer>(sideBCount);
        for (i = 0; i < sideACount; ++i) {
            this.sideA.add(buf.readInt());
        }
        for (i = 0; i < sideBCount; ++i) {
            this.sideB.add(buf.readInt());
        }
        this.decisionNanos = buf.readLong();
        this.maxDecisionNanos = buf.readLong();
        this.turnTimerEnabled = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.sideA.size());
        buf.writeInt(this.sideB.size());
        for (Integer id : this.sideA) {
            buf.writeInt(id.intValue());
        }
        for (Integer id : this.sideB) {
            buf.writeInt(id.intValue());
        }
        buf.writeLong(this.decisionNanos);
        buf.writeLong(this.maxDecisionNanos);
        buf.writeBoolean(this.turnTimerEnabled);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static class PayloadHandler {
        private static final PayloadHandler INSTANCE = new PayloadHandler();

        public static PayloadHandler getInstance() {
            return INSTANCE;
        }

        public void handleData(PacketBattleInfo pkt, PlayPayloadContext ctx) {
            ctx.workHandler().submitAsync(() -> {
                Entity e;
                if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
                    return;
                }
                TurnBasedMinecraftMod.proxy.getLocalBattle().clearCombatants();
                for (Integer id : pkt.sideA) {
                    e = Minecraft.getInstance().level.getEntity(id.intValue());
                    if (e == null) continue;
                    TurnBasedMinecraftMod.proxy.getLocalBattle().addCombatantToSideA(e);
                }
                for (Integer id : pkt.sideB) {
                    e = Minecraft.getInstance().level.getEntity(id.intValue());
                    if (e == null) continue;
                    TurnBasedMinecraftMod.proxy.getLocalBattle().addCombatantToSideB(e);
                }
                TurnBasedMinecraftMod.proxy.setBattleGuiTime((int)(pkt.decisionNanos / 1000000000L));
                TurnBasedMinecraftMod.proxy.setBattleGuiBattleChanged();
                TurnBasedMinecraftMod.proxy.setBattleGuiTurnTimerEnabled(pkt.turnTimerEnabled);
                TurnBasedMinecraftMod.proxy.setBattleGuiTurnTimerMax((int)(pkt.maxDecisionNanos / 1000000000L));
            }).exceptionally(e -> {
                ctx.packetHandler().disconnect((Component)Component.literal((String)("Exception handling PacketBattleInfo! " + e.getMessage())));
                return null;
            });
        }
    }
}

