/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketBattleRequestInfo
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("com_burnedkirby_turnbasedminecraft", "network_packetbattlerequestinfo");
    private int battleID;

    public PacketBattleRequestInfo() {
    }

    public PacketBattleRequestInfo(int battleID) {
        this.battleID = battleID;
    }

    public PacketBattleRequestInfo(FriendlyByteBuf buf) {
        this.battleID = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.battleID);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static class PayloadHandler {
        private static final PayloadHandler INSTANCE = new PayloadHandler();

        public static PayloadHandler getInstance() {
            return INSTANCE;
        }

        public void handleData(PacketBattleRequestInfo pkt, PlayPayloadContext ctx) {
            ctx.workHandler().submitAsync(() -> {
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(pkt.battleID);
                if (b == null) {
                    return;
                }
                ctx.replyHandler().send((CustomPacketPayload)new PacketBattleInfo(b.getSideAIDs(), b.getSideBIDs(), b.getTimerNanos(), TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos(), !TurnBasedMinecraftMod.proxy.getConfig().isBattleDecisionDurationForever()));
            }).exceptionally(e -> {
                ctx.packetHandler().disconnect((Component)Component.literal((String)("Exception handling PacketBattleRequestInfo! " + e.getMessage())));
                return null;
            });
        }
    }
}

