/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.BattleGui;
import com.burnedkirby.TurnBasedMinecraft.client.BattleMusic;
import com.burnedkirby.TurnBasedMinecraft.client.ClientConfig;
import com.burnedkirby.TurnBasedMinecraft.client.ClientConfigGui;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientProxy
extends CommonProxy {
    private BattleGui battleGui = null;
    private BattleMusic battleMusic = null;
    private int battleMusicCount = 0;
    private int sillyMusicCount = 0;
    private Battle localBattle = null;

    @Override
    protected void initializeClient() {
        this.battleGui = new BattleGui();
        this.battleMusic = null;
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
        this.localBattle = null;
        this.logger.debug("Init client");
    }

    @Override
    public void setBattleGuiTime(int timeRemaining) {
        this.battleGui.setTimeRemaining(timeRemaining);
    }

    @Override
    public void setBattleGuiBattleChanged() {
        this.battleGui.battleChanged();
    }

    @Override
    public void setBattleGuiAsGui() {
        if (Minecraft.getInstance().screen != this.battleGui) {
            this.battleGui.turnEnd();
            Minecraft.getInstance().setScreen((Screen)this.battleGui);
        }
    }

    @Override
    public void setBattleGuiTurnTimerEnabled(boolean enabled) {
        this.battleGui.setTurnTimerEnabled(enabled);
    }

    @Override
    public void setBattleGuiTurnTimerMax(int timeMax) {
        this.battleGui.setTurnTimerMax(timeMax);
    }

    @Override
    public void battleGuiTurnBegin() {
        this.battleGui.turnBegin();
    }

    @Override
    public void battleGuiTurnEnd() {
        this.battleGui.turnEnd();
    }

    @Override
    public void battleStarted() {
        this.setBattleGuiAsGui();
    }

    @Override
    public void battleEnded() {
        this.localBattle = null;
        Minecraft.getInstance().setScreen(null);
        this.stopMusic(true);
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
    }

    @Override
    protected void postInitClient() {
        this.battleMusic = new BattleMusic(this.getLogger());
    }

    @Override
    public void playBattleMusic() {
        Options gs = Minecraft.getInstance().options;
        float volume = ((Double)ClientConfig.CLIENT.musicVolume.get()).floatValue();
        if (((Boolean)ClientConfig.CLIENT.volumeAffectedByMasterVolume.get()).booleanValue()) {
            volume *= gs.getSoundSourceVolume(SoundSource.MASTER);
        }
        if (((Boolean)ClientConfig.CLIENT.volumeAffectedByMusicVolume.get()).booleanValue()) {
            volume *= gs.getSoundSourceVolume(SoundSource.MUSIC);
        }
        this.battleMusic.playBattle(volume);
    }

    @Override
    public void playSillyMusic() {
        Options gs = Minecraft.getInstance().options;
        float volume = ((Double)ClientConfig.CLIENT.musicVolume.get()).floatValue();
        if (((Boolean)ClientConfig.CLIENT.volumeAffectedByMasterVolume.get()).booleanValue()) {
            volume *= gs.getSoundSourceVolume(SoundSource.MASTER);
        }
        if (((Boolean)ClientConfig.CLIENT.volumeAffectedByMusicVolume.get()).booleanValue()) {
            volume *= gs.getSoundSourceVolume(SoundSource.MUSIC);
        }
        this.battleMusic.playSilly(volume);
    }

    @Override
    public void stopMusic(boolean resumeMCSounds) {
        this.battleMusic.stopMusic(resumeMCSounds);
    }

    @Override
    public void typeEnteredBattle(String type) {
        if (this.localBattle == null) {
            return;
        }
        if (type == null || type.isEmpty() || ((List)ClientConfig.CLIENT.battleMusicList.get()).contains(type)) {
            ++this.battleMusicCount;
        } else if (((List)ClientConfig.CLIENT.sillyMusicList.get()).contains(type)) {
            ++this.sillyMusicCount;
        } else {
            ++this.battleMusicCount;
        }
        this.checkBattleTypes(false);
    }

    @Override
    public void typeLeftBattle(String type) {
        if (this.localBattle == null || this.localBattle.getSideA().isEmpty() || this.localBattle.getSideB().isEmpty()) {
            this.battleMusicCount = 0;
            this.sillyMusicCount = 0;
            return;
        }
        if (type == null || type.isEmpty() || ((List)ClientConfig.CLIENT.battleMusicList.get()).contains(type)) {
            --this.battleMusicCount;
        } else if (((List)ClientConfig.CLIENT.sillyMusicList.get()).contains(type)) {
            --this.sillyMusicCount;
        } else {
            --this.battleMusicCount;
        }
        this.checkBattleTypes(true);
    }

    @Override
    public void displayString(String message) {
        MutableComponent parentComponent = Component.empty();
        MutableComponent prefix = Component.literal((String)"TBM: ");
        prefix.setStyle(prefix.getStyle().withColor(TextColor.fromRgb((int)-16711936)).withBold(Boolean.valueOf(true)));
        MutableComponent text = Component.literal((String)message);
        text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
        parentComponent.getSiblings().add(prefix);
        parentComponent.getSiblings().add(text);
        Minecraft.getInstance().player.displayClientMessage((Component)parentComponent, false);
    }

    @Override
    public void displayComponent(Component text) {
        MutableComponent parentComponent = Component.empty();
        MutableComponent prefix = Component.literal((String)"TBM: ");
        prefix.setStyle(prefix.getStyle().withColor(TextColor.fromRgb((int)-16711936)).withBold(Boolean.valueOf(true)));
        parentComponent.getSiblings().add(prefix);
        parentComponent.getSiblings().add(text);
        Minecraft.getInstance().player.displayClientMessage((Component)parentComponent, false);
    }

    private void checkBattleTypes(boolean entityLeft) {
        if (this.localBattle == null && entityLeft && (this.localBattle.getSideA().isEmpty() || this.localBattle.getSideB().isEmpty())) {
            return;
        }
        double percentage = 0.0;
        percentage = this.sillyMusicCount == 0 && this.battleMusicCount == 0 ? 0.0 : (this.battleMusicCount == 0 ? 1.0 : (double)this.sillyMusicCount / (double)(this.sillyMusicCount + this.battleMusicCount));
        if (percentage >= (Double)ClientConfig.CLIENT.sillyMusicThreshold.get()) {
            if (this.battleMusic.isPlaying()) {
                if (!this.battleMusic.isPlayingSilly() && this.battleMusic.hasSillyMusic()) {
                    this.stopMusic(false);
                    this.playSillyMusic();
                }
            } else if (this.battleMusic.hasSillyMusic()) {
                this.playSillyMusic();
            }
        } else if (this.battleMusic.isPlaying()) {
            if (this.battleMusic.isPlayingSilly() && this.battleMusic.hasBattleMusic()) {
                this.stopMusic(false);
                this.playBattleMusic();
            }
        } else if (this.battleMusic.hasBattleMusic()) {
            this.playBattleMusic();
        }
    }

    @Override
    public Battle getLocalBattle() {
        return this.localBattle;
    }

    @Override
    public void createLocalBattle(int id) {
        this.localBattle = new Battle(null, id, null, null, false, (ResourceKey<Level>)Minecraft.getInstance().level.dimension());
    }

    @Override
    public Entity getEntity(int id, ResourceKey<Level> dim) {
        return Minecraft.getInstance().level.getEntity(id);
    }

    @Override
    public <MSG> void handlePacket(MSG msg, IPayloadContext ctx) {
        if (msg.getClass() == PacketBattleMessage.class) {
            PacketBattleMessage pkt = (PacketBattleMessage)msg;
            Entity fromEntity = this.getEntity(pkt.getEntityIDFrom(), pkt.getDimension());
            MutableComponent from = Component.literal((String)"Unknown");
            if (fromEntity != null) {
                from = fromEntity.getDisplayName();
            } else if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null && (fromEntity = TurnBasedMinecraftMod.proxy.getLocalBattle().getCombatantEntity(pkt.getEntityIDFrom())) != null) {
                from = fromEntity.getDisplayName();
            }
            Entity toEntity = TurnBasedMinecraftMod.proxy.getEntity(pkt.getEntityIDTo(), pkt.getDimension());
            MutableComponent to = Component.literal((String)"Unknown");
            if (toEntity != null) {
                to = toEntity.getDisplayName();
            } else if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null && (toEntity = TurnBasedMinecraftMod.proxy.getLocalBattle().getCombatantEntity(pkt.getEntityIDTo())) != null) {
                to = toEntity.getDisplayName();
            }
            MutableComponent parentComponent = Component.empty();
            block0 : switch (pkt.getMessageType()) {
                case ENTERED: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" entered battle!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null || TurnBasedMinecraftMod.proxy.getLocalBattle().getId() != pkt.getAmount()) {
                        TurnBasedMinecraftMod.proxy.createLocalBattle(pkt.getAmount());
                    }
                    TurnBasedMinecraftMod.proxy.battleStarted();
                    TurnBasedMinecraftMod.proxy.typeEnteredBattle(pkt.getCustom());
                    break;
                }
                case FLEE: {
                    if (pkt.getAmount() != 0) {
                        parentComponent.getSiblings().add(from);
                        parentComponent.getSiblings().add(Component.literal((String)" fled battle!"));
                        TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                        TurnBasedMinecraftMod.proxy.typeLeftBattle(pkt.getCustom());
                        break;
                    }
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" tried to flee battle but failed!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DIED: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" died in battle!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    TurnBasedMinecraftMod.proxy.typeLeftBattle(pkt.getCustom());
                    break;
                }
                case ENDED: {
                    TurnBasedMinecraftMod.proxy.displayString("Battle has ended!");
                    TurnBasedMinecraftMod.proxy.battleEnded();
                    break;
                }
                case ATTACK: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" attacked "));
                    parentComponent.getSiblings().add(to);
                    parentComponent.getSiblings().add(Component.literal((String)" and dealt "));
                    parentComponent.getSiblings().add(Component.literal((String)Integer.valueOf(pkt.getAmount()).toString()));
                    parentComponent.getSiblings().add(Component.literal((String)" damage!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DEFEND: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" blocked "));
                    parentComponent.getSiblings().add(to);
                    parentComponent.getSiblings().add(Component.literal((String)"'s attack!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DEFENSE_DAMAGE: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" retaliated from "));
                    parentComponent.getSiblings().add(to);
                    parentComponent.getSiblings().add(Component.literal((String)"'s attack and dealt "));
                    parentComponent.getSiblings().add(Component.literal((String)Integer.valueOf(pkt.getAmount()).toString()));
                    parentComponent.getSiblings().add(Component.literal((String)" damage!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case MISS: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" attacked "));
                    parentComponent.getSiblings().add(to);
                    parentComponent.getSiblings().add(Component.literal((String)" but missed!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DEFENDING: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" is defending!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DID_NOTHING: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" did nothing!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case USED_ITEM: {
                    parentComponent.getSiblings().add(from);
                    switch (PacketBattleMessage.UsedItemAction.valueOf(pkt.getAmount())) {
                        case USED_NOTHING: {
                            parentComponent.getSiblings().add(Component.literal((String)" tried to use nothing!"));
                            TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                            break block0;
                        }
                        case USED_INVALID: {
                            if (pkt.getCustom().length() > 0) {
                                parentComponent.getSiblings().add(Component.literal((String)" tried to use "));
                                parentComponent.getSiblings().add(Component.literal((String)pkt.getCustom()));
                                parentComponent.getSiblings().add(Component.literal((String)"!"));
                                TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                                break block0;
                            }
                            parentComponent.getSiblings().add(Component.literal((String)" tried to use an item!"));
                            TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                            break block0;
                        }
                        case USED_FOOD: {
                            parentComponent.getSiblings().add(Component.literal((String)" ate a "));
                            parentComponent.getSiblings().add(Component.literal((String)pkt.getCustom()));
                            parentComponent.getSiblings().add(Component.literal((String)"!"));
                            TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                            break block0;
                        }
                        case USED_POTION: {
                            parentComponent.getSiblings().add(Component.literal((String)" drank a "));
                            parentComponent.getSiblings().add(Component.literal((String)pkt.getCustom()));
                            parentComponent.getSiblings().add(Component.literal((String)"!"));
                            TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                        }
                    }
                    break;
                }
                case TURN_BEGIN: {
                    TurnBasedMinecraftMod.proxy.displayString("The turn begins!");
                    if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null || TurnBasedMinecraftMod.proxy.getLocalBattle().getId() != pkt.getAmount()) {
                        TurnBasedMinecraftMod.proxy.createLocalBattle(pkt.getAmount());
                    }
                    TurnBasedMinecraftMod.proxy.battleStarted();
                    TurnBasedMinecraftMod.proxy.battleGuiTurnBegin();
                    break;
                }
                case TURN_END: {
                    if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
                        if (pkt.getAmount() == 0) {
                            TurnBasedMinecraftMod.proxy.displayString("The turn ended!");
                        } else {
                            TurnBasedMinecraftMod.proxy.displayString("The turn ended (abnormally due to internal error)!");
                        }
                    }
                    TurnBasedMinecraftMod.proxy.battleGuiTurnEnd();
                    break;
                }
                case SWITCHED_ITEM: {
                    if (pkt.getAmount() != 0) {
                        parentComponent.getSiblings().add(from);
                        parentComponent.getSiblings().add(Component.literal((String)" switched to a different item!"));
                        TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                        break;
                    }
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" switched to a different item but failed because it was invalid!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case WAS_AFFECTED: {
                    parentComponent.getSiblings().add(to);
                    parentComponent.getSiblings().add(Component.literal((String)(" was " + pkt.getCustom() + " by ")));
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)"!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case BECAME_CREATIVE: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" entered creative mode and left battle!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case FIRED_ARROW: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" let loose an arrow towards "));
                    parentComponent.getSiblings().add(to);
                    parentComponent.getSiblings().add(Component.literal((String)"!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case ARROW_HIT: {
                    parentComponent.getSiblings().add(to);
                    parentComponent.getSiblings().add(Component.literal((String)" was hit by "));
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)"'s arrow!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case BOW_NO_AMMO: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" tried to use their bow but ran out of ammo!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case CREEPER_WAIT: {
                    parentComponent.getSiblings().add(from);
                    MutableComponent message = Component.literal((String)" is charging up!");
                    message.setStyle(message.getStyle().withColor(TextColor.fromRgb((int)-256)));
                    parentComponent.getSiblings().add(message);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case CREEPER_WAIT_FINAL: {
                    parentComponent.getSiblings().add(from);
                    MutableComponent message = Component.literal((String)" is about to explode!");
                    message.setStyle(message.getStyle().withColor(TextColor.fromRgb((int)-44976)));
                    parentComponent.getSiblings().add(message);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case CREEPER_EXPLODE: {
                    parentComponent.getSiblings().add(from);
                    MutableComponent message = Component.literal((String)" exploded!");
                    message.setStyle(message.getStyle().withColor(TextColor.fromRgb((int)-65536)));
                    parentComponent.getSiblings().add(message);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                }
                case CROSSBOW_NO_AMMO: {
                    parentComponent.getSiblings().add(from);
                    parentComponent.getSiblings().add(Component.literal((String)" tried to use their crossbow but ran out of ammo!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                }
            }
        } else if (msg.getClass() == PacketGeneralMessage.class) {
            PacketGeneralMessage pkt = (PacketGeneralMessage)msg;
            this.displayString(pkt.getMessage());
        } else if (msg.getClass() == PacketEditingMessage.class) {
            PacketEditingMessage pkt = (PacketEditingMessage)msg;
            MutableComponent parentComponent = Component.empty();
            switch (pkt.getType()) {
                case ATTACK_ENTITY: {
                    MutableComponent text = Component.literal((String)"Attack the entity you want to edit for TurnBasedMinecraftMod. ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    MutableComponent cancel = Component.literal((String)"Cancel");
                    cancel.setStyle(cancel.getStyle().withColor(TextColor.fromRgb((int)-65536)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit cancel")));
                    parentComponent.getSiblings().add(text);
                    parentComponent.getSiblings().add(cancel);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case PICK_EDIT: {
                    MutableComponent value;
                    MutableComponent option;
                    MutableComponent text = Component.literal((String)"Edit what value? ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    if (pkt.getEntityInfo().playerName.isEmpty()) {
                        option = Component.literal((String)"IgB");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"IgnoreBattle"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().ignoreBattle + ") "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                        option = Component.literal((String)"AP");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackPower")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"AttackPower"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().attackPower + ") "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                    }
                    option = Component.literal((String)"APr");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackProbability")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"AttackProbability"))));
                    value = Component.literal((String)("(" + pkt.getEntityInfo().attackProbability + "%) "));
                    value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                    option.getSiblings().add(value);
                    text.getSiblings().add(option);
                    if (pkt.getEntityInfo().playerName.isEmpty()) {
                        option = Component.literal((String)"AV");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackVariance")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"AttackVariance"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().attackVariance + ") "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                    }
                    option = Component.literal((String)"AE");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffect")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"AttackEffect"))));
                    value = Component.literal((String)("(" + pkt.getEntityInfo().attackEffect.toString() + ") "));
                    value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                    option.getSiblings().add(value);
                    text.getSiblings().add(option);
                    option = Component.literal((String)"AEPr");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffectProbability")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"AttackEffectProbability"))));
                    value = Component.literal((String)("(" + pkt.getEntityInfo().attackEffectProbability + "%) "));
                    value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                    option.getSiblings().add(value);
                    text.getSiblings().add(option);
                    if (pkt.getEntityInfo().playerName.isEmpty()) {
                        option = Component.literal((String)"DD");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamage")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"DefenseDamage"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().defenseDamage + ") "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                        option = Component.literal((String)"DDPr");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamageProbability")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"DefenseDamageProbability"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().defenseDamageProbability + "%) "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                    }
                    option = Component.literal((String)"E");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit evasion")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Evasion"))));
                    value = Component.literal((String)("(" + pkt.getEntityInfo().evasion + "%) "));
                    value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                    option.getSiblings().add(value);
                    text.getSiblings().add(option);
                    option = Component.literal((String)"S");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit speed")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Speed"))));
                    value = Component.literal((String)("(" + pkt.getEntityInfo().speed + ") "));
                    value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                    option.getSiblings().add(value);
                    text.getSiblings().add(option);
                    option = Component.literal((String)"HS");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit hasteSpeed")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"HasteSpeed"))));
                    value = Component.literal((String)("(" + pkt.getEntityInfo().hasteSpeed + ") "));
                    value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                    option.getSiblings().add(value);
                    text.getSiblings().add(option);
                    option = Component.literal((String)"SS");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit slowSpeed")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"SlowSpeed"))));
                    value = Component.literal((String)("(" + pkt.getEntityInfo().slowSpeed + ") "));
                    value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                    option.getSiblings().add(value);
                    text.getSiblings().add(option);
                    if (pkt.getEntityInfo().playerName.isEmpty()) {
                        option = Component.literal((String)"C");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Category"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().category + ") "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                        option = Component.literal((String)"DecA");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionAttack")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"DecisionAttack"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().decisionAttack + "%) "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                        option = Component.literal((String)"DecD");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionDefend")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"DecisionDefend"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().decisionDefend + "%) "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                        option = Component.literal((String)"DecF");
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionFlee")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"DecisionFlee"))));
                        value = Component.literal((String)("(" + pkt.getEntityInfo().decisionFlee + "%) "));
                        value.setStyle(value.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        option.getSiblings().add(value);
                        text.getSiblings().add(option);
                    }
                    option = Component.literal((String)"Finished Editing");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-16711936)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit finish")));
                    text.getSiblings().add(option);
                    text.getSiblings().add(Component.literal((String)" "));
                    option = Component.literal((String)"Cancel");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-65536)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit cancel")));
                    text.getSiblings().add(option);
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case SERVER_EDIT: {
                    int i;
                    MutableComponent parent = Component.literal((String)"Edit what server value? ");
                    parent.setStyle(parent.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    MutableComponent sub = Component.literal((String)"leave_battle_cooldown ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)));
                    parent.getSiblings().add(sub);
                    for (i = 1; i <= 10; ++i) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit leave_battle_cooldown " + i)));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"aggro_start_battle_max_distance ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"5 ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit aggro_start_battle_max_distance 5")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"8 ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit aggro_start_battle_max_distance 8")));
                    parent.getSiblings().add(sub);
                    for (i = 10; i <= 50; i += 5) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit aggro_start_battle_max_distance " + String.valueOf(i))));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"old_battle_behavior ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"If enabled, battles only start on a hit, not including mobs targeting players"))).withBold(Boolean.valueOf(true)));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"true ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit old_battle_behavior true")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"false ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit old_battle_behavior false")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"anyone_can_disable_tbm_for_self ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Allows use for /tbm-disable and /tbm-enable for all"))).withBold(Boolean.valueOf(true)));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"true ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit anyone_can_disable_tbm_for_self true")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"false ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit anyone_can_disable_tbm_for_self false")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"max_in_battle ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"2 ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit max_in_battle 2")));
                    parent.getSiblings().add(sub);
                    for (i = 5; i < 30; i += 5) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit max_in_battle " + String.valueOf(i))));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"freeze_battle_combatants ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"true ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit freeze_battle_combatants true")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"false ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit freeze_battle_combatants false")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"ignore_battle_types ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.DARK_GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_battle_types")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to show current ignored categories, or use /tbm-server-edit ignore_battle_types add/remove <category_name>"))).withBold(Boolean.valueOf(true)));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"player_speed ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Player default speed"))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 100; i += 5) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_speed " + i)));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"player_haste_speed ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Player speed when under the effects of \"Speed\""))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 100; i += 5) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_haste_speed " + i)));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"player_slow_speed ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Player speed when under the effects of \"Slow\""))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 100; i += 5) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_slow_speed " + i)));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"player_attack_probability ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Base Player attack probability in percentage"))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 100; i += 5) {
                        if (i == 0) {
                            sub = Component.literal((String)"1 ");
                            sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_attack_probability 1")));
                        } else {
                            sub = Component.literal((String)(String.valueOf(i) + " "));
                            sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_attack_probability " + i)));
                        }
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"player_evasion ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Base Player evasion rate in percentage"))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 100; i += 5) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_evasion " + i)));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"defense_duration ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Number of attacks that a \"Defend\" move blocks (lasts until next action)"))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 5; ++i) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit defense_duration " + i)));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"flee_good_probability ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Probability of flee success when Player's speed is higher than the fastest opposing Entity"))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 100; i += 5) {
                        if (i == 0) {
                            sub = Component.literal((String)"1 ");
                            sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit flee_good_probability 1")));
                        } else {
                            sub = Component.literal((String)(String.valueOf(i) + " "));
                            sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit flee_good_probability " + i)));
                        }
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"flee_bad_probability ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Probability of flee success when Player's speed is lower than the fastest opposing Entity"))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 100; i += 5) {
                        if (i == 0) {
                            sub = Component.literal((String)"1 ");
                            sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit flee_bad_probability 1")));
                        } else {
                            sub = Component.literal((String)(String.valueOf(i) + " "));
                            sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit flee_bad_probability " + i)));
                        }
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"minimum_hit_percentage ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"The minimum percentage possible when calculating hit percentage for any attacker"))));
                    parent.getSiblings().add(sub);
                    for (i = 0; i <= 100; i += 5) {
                        if (i == 0) {
                            sub = Component.literal((String)"1 ");
                            sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit minimum_hit_percentage 1")));
                        } else {
                            sub = Component.literal((String)(String.valueOf(i) + " "));
                            sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit minimum_hit_percentage " + i)));
                        }
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"battle_turn_wait_forever ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Disables the turn timer (recommended to leave this to false)"))));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"true ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit battle_turn_wait_forever true")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"false ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit battle_turn_wait_forever false")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"battle_turn_time_seconds ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"The time in seconds to wait for all Players to choose their move"))));
                    parent.getSiblings().add(sub);
                    for (i = 5; i <= 60; i += 5) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit battle_turn_time_seconds " + i)));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"creeper_explode_turn ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"The number of turns it takes for a creeper to explode"))));
                    parent.getSiblings().add(sub);
                    for (i = 1; i <= 10; ++i) {
                        sub = Component.literal((String)(String.valueOf(i) + " "));
                        sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_explode_turn " + i)));
                        parent.getSiblings().add(sub);
                    }
                    sub = Component.literal((String)"creeper_stop_explode_on_leave_battle ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Stops creepers from exploding when they leave battle (during leave battle cooldown)"))));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"true ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_stop_explode_on_leave_battle true")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"false ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_stop_explode_on_leave_battle false")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"creeper_always_allow_damage ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Allows creepers to damage anyone who just left battle (in cooldown)"))));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"true ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_always_allow_damage true")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"false ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_always_allow_damage false")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"ignore_damage_sources ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.DARK_GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_damage_sources")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to show current ignored damage sources (during battle), or use /tbm-server-edit ignore_damage_sources add/remove <type>"))).withBold(Boolean.valueOf(true)));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"player_only_battles ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Disables battle for non-player entities"))));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"enable ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_only_battles true")));
                    parent.getSiblings().add(sub);
                    sub = Component.literal((String)"disable ");
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_only_battles false")));
                    parent.getSiblings().add(sub);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parent);
                    break;
                }
                case EDIT_IGNORE_BATTLE: {
                    MutableComponent text = Component.literal((String)"ignoreBattle: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    MutableComponent option = Component.literal((String)"true");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-16711936)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle true")));
                    text.getSiblings().add(option);
                    text.getSiblings().add(Component.literal((String)" "));
                    option = Component.literal((String)"false");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-65536)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle false")));
                    text.getSiblings().add(option);
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_POWER: {
                    MutableComponent text = Component.literal((String)"attackPower: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 15; ++i) {
                        MutableComponent option = Component.literal((String)Integer.toString(i));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackPower " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 15) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit attackPower <integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_PROBABILITY: {
                    MutableComponent text = Component.literal((String)"attackProbability: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 10; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)(Integer.toString(i) + "%"));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackProbability " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit attackProbability <percentage-integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_VARIANCE: {
                    MutableComponent text = Component.literal((String)"attackVariance: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 10; ++i) {
                        MutableComponent option = Component.literal((String)Integer.toString(i));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackVariance " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 10) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit attackVariance <integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_EFFECT: {
                    MutableComponent text = Component.literal((String)"attackEffect: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (EntityInfo.Effect e : EntityInfo.Effect.values()) {
                        MutableComponent option = Component.literal((String)e.toString());
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffect " + e.toString())));
                        text.getSiblings().add(option);
                        if (e == EntityInfo.Effect.UNKNOWN) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_EFFECT_PROBABILITY: {
                    MutableComponent text = Component.literal((String)"attackEffectProbability: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)(Integer.toString(i) + "%"));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffectProbability " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit attackEffectProbability <percentage-integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DEFENSE_DAMAGE: {
                    MutableComponent text = Component.literal((String)"defenseDamage: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 15; ++i) {
                        MutableComponent option = Component.literal((String)Integer.toString(i));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamage " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 15) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit defenseDamage <integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DEFENSE_DAMAGE_PROBABILITY: {
                    MutableComponent text = Component.literal((String)"defenseDamageProbability: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)(Integer.toString(i) + "%"));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamageProbability " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit defenseDamageProbability <percentage-integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_EVASION: {
                    MutableComponent text = Component.literal((String)"evasion: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)(Integer.toString(i) + "%"));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit evasion " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit evasion <percentage-integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_SPEED: {
                    MutableComponent text = Component.literal((String)"speed: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)Integer.toString(i));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit speed " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit speed <integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_HASTE_SPEED: {
                    MutableComponent text = Component.literal((String)"haste speed: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)Integer.toString(i));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit hasteSpeed " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit hasteSpeed <integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_SLOW_SPEED: {
                    MutableComponent text = Component.literal((String)"slow speed: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)Integer.toString(i));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit slowSpeed " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit slowSpeed <integer>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_CATEGORY: {
                    MutableComponent optionInfoBool;
                    MutableComponent optionInfo;
                    MutableComponent text = Component.literal((String)"category: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    MutableComponent option = Component.literal((String)"monster");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category monster")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("monster")) {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"disabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-65536)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    } else {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"enabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-16711936)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    }
                    text.getSiblings().add(option);
                    text.getSiblings().add(Component.literal((String)", "));
                    option = Component.literal((String)"animal");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category animal")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("animal")) {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"disabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-65536)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    } else {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"enabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-16711936)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    }
                    text.getSiblings().add(option);
                    text.getSiblings().add(Component.literal((String)", "));
                    option = Component.literal((String)"passive");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category passive")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("passive")) {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"disabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-65536)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    } else {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"enabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-16711936)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    }
                    text.getSiblings().add(option);
                    text.getSiblings().add(Component.literal((String)", "));
                    option = Component.literal((String)"boss");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category boss")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("boss")) {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"disabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-65536)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    } else {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"enabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-16711936)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    }
                    text.getSiblings().add(option);
                    text.getSiblings().add(Component.literal((String)", "));
                    option = Component.literal((String)"player");
                    option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category player")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("player")) {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"disabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-65536)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    } else {
                        optionInfo = Component.literal((String)"(battle-");
                        optionInfo.setStyle(optionInfo.getStyle().withColor(TextColor.fromRgb((int)-1)));
                        optionInfoBool = Component.literal((String)"enabled");
                        optionInfoBool.setStyle(optionInfoBool.getStyle().withColor(TextColor.fromRgb((int)-16711936)));
                        optionInfo.getSiblings().add(optionInfoBool);
                        optionInfo.getSiblings().add(Component.literal((String)")"));
                        option.getSiblings().add(optionInfo);
                    }
                    text.getSiblings().add(option);
                    text.getSiblings().add(Component.literal((String)" (or use command \"/tbm-edit edit category <string>\")"));
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DECISION_ATTACK: {
                    MutableComponent text = Component.literal((String)"decisionAttack: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)(Integer.toString(i) + "%"));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionAttack " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DECISION_DEFEND: {
                    MutableComponent text = Component.literal((String)"decisionDefend: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)(Integer.toString(i) + "%"));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionDefend " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DECISION_FLEE: {
                    MutableComponent text = Component.literal((String)"decisionFlee: ");
                    text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)-1)).withBold(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        MutableComponent option = Component.literal((String)(Integer.toString(i) + "%"));
                        option.setStyle(option.getStyle().withColor(TextColor.fromRgb((int)-256)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionFlee " + Integer.toString(i))));
                        text.getSiblings().add(option);
                        if (i >= 100) continue;
                        text.getSiblings().add(Component.literal((String)", "));
                    }
                    parentComponent.getSiblings().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case PICK_PLAYER: {
                    TurnBasedMinecraftMod.proxy.displayString("Use \"/tbm-edit player <player_name>\"");
                    break;
                }
            }
        }
    }

    @Override
    public void showClientConfigGui() {
        Minecraft.getInstance().setScreen((Screen)new ClientConfigGui(null, null));
    }

    @Override
    public void pauseMCMusic() {
        Minecraft.getInstance().getSoundManager().pause();
    }

    @Override
    public void resumeMCMusic() {
        Minecraft.getInstance().getSoundManager().resume();
    }
}

