/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.client.ClientConfig;
import com.burnedkirby.TurnBasedMinecraft.client.ClientProxy;
import com.burnedkirby.TurnBasedMinecraft.common.AttackEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.DimensionChangedHandler;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.HurtEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.PlayerJoinEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattlePing;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleRequestInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketClientGUI;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="com_burnedkirby_turnbasedminecraft")
public class TurnBasedMinecraftMod {
    public static final String MODID = "com_burnedkirby_turnbasedminecraft";
    public static final String NAME = "Turn Based Minecraft Mod";
    public static final String VERSION = "1.26.5";
    public static final String CONFIG_FILENAME = "TBM_Config.toml";
    public static final String DEFAULT_CONFIG_FILENAME = "TBM_Config_DEFAULT.toml";
    public static final String CONFIG_DIRECTORY = "config/TurnBasedMinecraft/";
    public static final String CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config.toml";
    public static final String DEFAULT_CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml";
    public static final String CONFIG_INTERNAL_PATH = "/assets/com_burnedkirby_turnbasedminecraft/TBM_Config.toml";
    public static final String MUSIC_ROOT = "config/TurnBasedMinecraft/Music/";
    public static final String MUSIC_SILLY = "config/TurnBasedMinecraft/Music/silly/";
    public static final String MUSIC_BATTLE = "config/TurnBasedMinecraft/Music/battle/";
    private static final String PROTOCOL_VERSION = Integer.toString(4);
    private static final ResourceLocation HANDLER_ID = ResourceLocation.fromNamespaceAndPath((String)"com_burnedkirby_turnbasedminecraft", (String)"main_channel");
    protected static Logger logger = LogManager.getLogger();
    public static CommonProxy proxy;

    public static ResourceLocation getNetResourceLocation() {
        return HANDLER_ID;
    }

    public TurnBasedMinecraftMod(ModContainer container) {
        container.getEventBus().addListener(this::firstInit);
        container.getEventBus().addListener(this::secondInitClient);
        container.getEventBus().addListener(this::secondInitServer);
        container.getEventBus().addListener(this::registerNetwork);
        NeoForge.EVENT_BUS.register((Object)this);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_SPEC);
    }

    private void registerNetwork(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL_VERSION);
        registrar.playToServer(PacketBattleDecision.TYPE, PacketBattleDecision.STREAM_CODEC, (IPayloadHandler)new PacketBattleDecision.PayloadHandler());
        registrar.playToClient(PacketBattleInfo.TYPE, PacketBattleInfo.STREAM_CODEC, (IPayloadHandler)new PacketBattleInfo.PayloadHandler());
        registrar.playToClient(PacketBattleMessage.TYPE, PacketBattleMessage.STREAM_CODEC, (IPayloadHandler)new PacketBattleMessage.PayloadHandler());
        registrar.playToServer(PacketBattleRequestInfo.TYPE, PacketBattleRequestInfo.STREAM_CODEC, (IPayloadHandler)new PacketBattleRequestInfo.PayloadHandler());
        registrar.playToClient(PacketEditingMessage.TYPE, PacketEditingMessage.STREAM_CODEC, (IPayloadHandler)new PacketEditingMessage.PayloadHandler());
        registrar.playToClient(PacketGeneralMessage.TYPE, PacketGeneralMessage.STREAM_CODEC, (IPayloadHandler)new PacketGeneralMessage.PayloadHandler());
        registrar.playToClient(PacketClientGUI.TYPE, PacketClientGUI.STREAM_CODEC, (IPayloadHandler)new PacketClientGUI.PayloadHandler());
        registrar.playToClient(PacketBattlePing.TYPE, PacketBattlePing.STREAM_CODEC, (IPayloadHandler)new PacketBattlePing.PayloadHandler());
        logger.debug("Register packets com_burnedkirby_turnbasedminecraft");
    }

    private void firstInit(FMLCommonSetupEvent event) {
        proxy = FMLEnvironment.dist.isClient() ? new ClientProxy() : new CommonProxy();
        proxy.setLogger(logger);
        proxy.initialize();
        NeoForge.EVENT_BUS.register((Object)new AttackEventHandler());
        NeoForge.EVENT_BUS.register((Object)new PlayerJoinEventHandler());
        NeoForge.EVENT_BUS.register((Object)new DimensionChangedHandler());
        NeoForge.EVENT_BUS.register((Object)new HurtEventHandler());
        logger.debug("Init com_burnedkirby_turnbasedminecraft");
    }

    private void secondInitClient(FMLClientSetupEvent event) {
        proxy.postInit();
    }

    private void secondInitServer(FMLDedicatedServerSetupEvent event) {
        proxy.postInit();
    }

    @SubscribeEvent
    public void serverStarting(ServerStartingEvent event) {
        logger.debug("About to initialize BattleManager");
        if (proxy.initializeBattleManager()) {
            logger.debug("Initialized BattleManager");
        }
        proxy.getConfig().clearBattleIgnoringPlayers();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbm-disable").requires(c -> !proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf() || c.hasPermission(2))).executes(c -> {
            proxy.getConfig().addBattleIgnoringPlayer(((CommandSourceStack)c.getSource()).getPlayerOrException().getId());
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Disabled turn-based-combat for current player"), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbm-disable-all").requires(c -> c.hasPermission(2))).executes(c -> {
            proxy.getConfig().setBattleDisabledForAll(true);
            for (ServerPlayer player : ((CommandSourceStack)c.getSource()).getServer().getPlayerList().getPlayers()) {
                proxy.getConfig().addBattleIgnoringPlayer(player.getId());
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketGeneralMessage("OP disabled turn-based-combat for everyone"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbm-enable").requires(c -> !proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf() || c.hasPermission(2))).executes(c -> {
            proxy.getConfig().removeBattleIgnoringPlayer(((CommandSourceStack)c.getSource()).getPlayerOrException().getId());
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Enabled turn-based-combat for current player"), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbm-enable-all").requires(c -> c.hasPermission(2))).executes(c -> {
            proxy.getConfig().setBattleDisabledForAll(false);
            proxy.getConfig().clearBattleIgnoringPlayers();
            for (ServerPlayer player : ((CommandSourceStack)c.getSource()).getServer().getPlayerList().getPlayers()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketGeneralMessage("OP enabled turn-based-combat for everyone"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbm-set-enable").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(c -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)c, (String)"targets")) {
                proxy.getConfig().addBattleIgnoringPlayer(player.getId());
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketGeneralMessage("OP enabled turn-based-combat for you"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Enabled turn-based-combat for " + player.getDisplayName().getString())), true);
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbm-set-disable").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(c -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)c, (String)"targets")) {
                proxy.getConfig().removeBattleIgnoringPlayer(player.getId());
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketGeneralMessage("OP disabled turn-based-combat for you"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Disabled turn-based-combat for " + player.getDisplayName().getString())), true);
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbm-edit").requires(c -> c.hasPermission(2))).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                proxy.setEditingPlayer((Player)player);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                logger.info("Begin editing TBM Entity for player \"" + player.getDisplayName().getString() + "\" (\"" + String.valueOf(((CommandSourceStack)c.getSource()).getDisplayName()) + "\")");
            }
            return 1;
        })).then(Commands.literal((String)"finish").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                if (!proxy.getConfig().editEntityEntry(editingInfo.entityInfo)) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketGeneralMessage("An error occurred while attempting to save an entry to the config"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    proxy.removeEditingInfo(player.getId());
                } else {
                    proxy.removeEditingInfo(player.getId());
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketGeneralMessage("Entity info saved in config and loaded."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        }))).then(Commands.literal((String)"cancel").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null) {
                proxy.removeEditingInfo(player.getId());
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketGeneralMessage("Cancelled editing entry."), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return 1;
        }))).then(Commands.literal((String)"custom").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                LiteralMessage exceptionMessage = new LiteralMessage("Invalid action for tbm-edit");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                proxy.setEditingPlayer((Player)player);
                TurnBasedMinecraftMod.proxy.getEditingInfo((int)player.getId()).isEditingCustomName = true;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                logger.info("Begin editing custom TBM Entity for player \"" + player.getDisplayName().getString() + "\" (\"" + String.valueOf(((CommandSourceStack)c.getSource()).getDisplayName()) + "\")");
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"player").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_PLAYER), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        })).then(Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String name = StringArgumentType.getString((CommandContext)c, (String)"playerName");
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketGeneralMessage("Editing player \"" + name + "\""), (CustomPacketPayload[])new CustomPacketPayload[0]);
            logger.info("Begin editing player \"" + name + "\"");
            proxy.setEditingPlayer((Player)player);
            EditingInfo editInfo = proxy.getEditingInfo(player.getId());
            editInfo.isEditingPlayer = true;
            editInfo.entityInfo = proxy.getConfig().getPlayerInfo(name);
            if (editInfo.entityInfo == null) {
                editInfo.entityInfo = new EntityInfo();
            }
            editInfo.entityInfo.playerName = name;
            editInfo.isPendingEntitySelection = false;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"edit").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"ignoreBattle").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_IGNORE_BATTLE), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"ignoreBattle", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            boolean ignoreBattle = BoolArgumentType.getBool((CommandContext)c, (String)"ignoreBattle");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.ignoreBattle = ignoreBattle;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"attackPower").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_POWER), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"attackPower", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int attackPower = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackPower");
            if (attackPower < 0) {
                attackPower = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackPower = attackPower;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"attackProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_PROBABILITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"attackProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int attackProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackProbability");
            if (attackProbability < 0) {
                attackProbability = 0;
            } else if (attackProbability > 100) {
                attackProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackProbability = attackProbability;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"attackVariance").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_VARIANCE), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"attackVariance", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int attackVariance = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackVariance");
            if (attackVariance < 0) {
                attackVariance = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackVariance = attackVariance;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"attackEffect").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_EFFECT), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"attackEffect", (ArgumentType)StringArgumentType.word()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            EntityInfo.Effect effect = EntityInfo.Effect.fromString(StringArgumentType.getString((CommandContext)c, (String)"attackEffect"));
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackEffect = effect;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"attackEffectProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_EFFECT_PROBABILITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"attackEffectProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int attackEffectProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackEffectProbability");
            if (attackEffectProbability < 0) {
                attackEffectProbability = 0;
            } else if (attackEffectProbability > 100) {
                attackEffectProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackEffectProbability = attackEffectProbability;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"defenseDamage").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DEFENSE_DAMAGE), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"defenseDamage", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int defenseDamage = IntegerArgumentType.getInteger((CommandContext)c, (String)"defenseDamage");
            if (defenseDamage < 0) {
                defenseDamage = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.defenseDamage = defenseDamage;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"defenseDamageProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DEFENSE_DAMAGE_PROBABILITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"defenseDamageProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int defenseDamageProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"defenseDamageProbability");
            if (defenseDamageProbability < 0) {
                defenseDamageProbability = 0;
            } else if (defenseDamageProbability > 100) {
                defenseDamageProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.defenseDamageProbability = defenseDamageProbability;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"evasion").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_EVASION), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"evasion", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int evasion = IntegerArgumentType.getInteger((CommandContext)c, (String)"evasion");
            if (evasion < 0) {
                evasion = 0;
            } else if (evasion > 100) {
                evasion = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.evasion = evasion;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"speed").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_SPEED), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"speed");
            if (speed < 0) {
                speed = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.speed = speed;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"hasteSpeed").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_HASTE_SPEED), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"hasteSpeed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int hasteSpeed = IntegerArgumentType.getInteger((CommandContext)c, (String)"hasteSpeed");
            if (hasteSpeed < 0) {
                hasteSpeed = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.hasteSpeed = hasteSpeed;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"slowSpeed").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_SLOW_SPEED), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"slowSpeed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int slowSpeed = IntegerArgumentType.getInteger((CommandContext)c, (String)"slowSpeed");
            if (slowSpeed < 0) {
                slowSpeed = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.slowSpeed = slowSpeed;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"category").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_CATEGORY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"category", (ArgumentType)StringArgumentType.word()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            String category = StringArgumentType.getString((CommandContext)c, (String)"category");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.category = category;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"decisionAttack").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_ATTACK), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"decisionAttack", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int decisionAttack = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionAttack");
            if (decisionAttack < 0) {
                decisionAttack = 0;
            } else if (decisionAttack > 100) {
                decisionAttack = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionAttack = decisionAttack;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"decisionDefend").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_DEFEND), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"decisionDefend", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int decisionDefend = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionDefend");
            if (decisionDefend < 0) {
                decisionDefend = 0;
            } else if (decisionDefend > 100) {
                decisionDefend = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionDefend = decisionDefend;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"decisionFlee").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_FLEE), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.argument((String)"decisionFlee", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            EditingInfo editingInfo = proxy.getEditingInfo(player.getId());
            int decisionFlee = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionFlee");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionFlee = decisionFlee;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (editingInfo != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbm-server-edit").requires(c -> c.hasPermission(2))).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.SERVER_EDIT), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"leave_battle_cooldown").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent response = Component.literal((String)"leave_battle_cooldown requires an integer argument. ");
                MutableComponent subResponse = Component.literal((String)"leave_battle_cooldown is currently: ");
                response.getSiblings().add(subResponse);
                subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getLeaveBattleCooldownSeconds()));
                subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                response.getSiblings().add(subResponse);
                return response;
            }, false);
            return 1;
        })).then(Commands.argument((String)"cooldown_seconds", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int cooldown = IntegerArgumentType.getInteger((CommandContext)c, (String)"cooldown_seconds");
            proxy.getConfig().setLeaveBattleCooldownSeconds(cooldown);
            cooldown = proxy.getConfig().getLeaveBattleCooldownSeconds();
            if (!proxy.getConfig().updateConfig("server_config.leave_battle_cooldown", cooldown)) {
                logger.warn("Failed to set \"server_config.leave_battle_cooldown\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set leave_battle_cooldown to \"" + cooldown + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set leave_battle_cooldown to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getLeaveBattleCooldownSeconds()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"aggro_start_battle_max_distance").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent response = Component.literal((String)"aggro_start_battle_max_distance requires an integer argument. ");
                MutableComponent subResponse = Component.literal((String)"aggro_start_battle_max_distance is currently: ");
                response.getSiblings().add(subResponse);
                subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getAggroStartBattleDistance()));
                subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                response.getSiblings().add(subResponse);
                return response;
            }, false);
            return 1;
        })).then(Commands.argument((String)"aggro_distance", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int distance = IntegerArgumentType.getInteger((CommandContext)c, (String)"aggro_distance");
            proxy.getConfig().setAggroStartBattleDistance(distance);
            distance = proxy.getConfig().getAggroStartBattleDistance();
            if (!proxy.getConfig().updateConfig("server_config.aggro_start_battle_max_distance", distance)) {
                logger.warn("Failed to set \"server_config.aggro_start_battle_max_distance\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set aggro_start_battle_max_distance to \"" + distance + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set aggro_start_battle_max_distance to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getAggroStartBattleDistance()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"old_battle_behavior").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent response = Component.literal((String)"old_battle_behavior requires a boolean argument. ");
                MutableComponent subResponse = Component.literal((String)"old_battle_behavior is currently: ");
                response.getSiblings().add(subResponse);
                subResponse = Component.literal((String)String.valueOf(proxy.getConfig().isOldBattleBehaviorEnabled()));
                subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                response.getSiblings().add(subResponse);
                return response;
            }, false);
            return 1;
        })).then(Commands.argument((String)"old_battle_behavior_enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)c, (String)"old_battle_behavior_enabled");
            proxy.getConfig().setOldBattleBehavior(enabled);
            if (!proxy.getConfig().updateConfig("server_config.old_battle_behavior", enabled)) {
                logger.warn("Failed to set \"server_config.old_battle_behavior\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set old_battle_behavior to \"" + enabled + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set old_battle_behavior to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(enabled));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"anyone_can_disable_tbm_for_self").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent response = Component.literal((String)"anyone_can_disable_tbm_for_self requires a boolean argument. ");
                MutableComponent subResponse = Component.literal((String)"anyone_can_disable_tbm_for_self is currently: ");
                response.getSiblings().add(subResponse);
                subResponse = Component.literal((String)String.valueOf(!proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf()));
                subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                response.getSiblings().add(subResponse);
                return response;
            }, false);
            return 1;
        })).then(Commands.argument((String)"enabled_for_all", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean enabled_for_all = BoolArgumentType.getBool((CommandContext)c, (String)"enabled_for_all");
            proxy.getConfig().setIfOnlyOPsCanDisableTurnBasedForSelf(!enabled_for_all);
            if (!proxy.getConfig().updateConfig("server_config.anyone_can_disable_tbm_for_self", enabled_for_all)) {
                logger.warn("Failed to set \"server_config.anyone_can_disable_tbm_for_self\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set anyone_can_disable_tbm_for_self to \"" + enabled_for_all + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set anyone_can_disable_tbm_for_self to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(enabled_for_all));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"max_in_battle").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent response = Component.literal((String)"max_in_battle requires an integer argument. ");
                MutableComponent subResponse = Component.literal((String)"max_in_battle is currently: ");
                response.getSiblings().add(subResponse);
                subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getMaxInBattle()));
                subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                response.getSiblings().add(subResponse);
                return response;
            }, false);
            return 1;
        })).then(Commands.argument((String)"max_amount", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int max_amount = IntegerArgumentType.getInteger((CommandContext)c, (String)"max_amount");
            proxy.getConfig().setMaxInBattle(max_amount);
            max_amount = proxy.getConfig().getMaxInBattle();
            if (!proxy.getConfig().updateConfig("server_config.max_in_battle", max_amount)) {
                logger.warn("Failed to set \"server_config.max_in_battle\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set max_in_battle to \"" + max_amount + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set max_in_battle to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getMaxInBattle()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"freeze_battle_combatants").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent response = Component.literal((String)"freeze_battle_combatants requires a boolean argument. ");
                MutableComponent subResponse = Component.literal((String)"freeze_battle_combatants is currently: ");
                response.getSiblings().add(subResponse);
                subResponse = Component.literal((String)String.valueOf(!proxy.getConfig().isFreezeCombatantsEnabled()));
                subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                response.getSiblings().add(subResponse);
                return response;
            }, false);
            return 1;
        })).then(Commands.argument((String)"freeze_enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)c, (String)"freeze_enabled");
            proxy.getConfig().setFreezeCombatantsInBattle(enabled);
            if (!proxy.getConfig().updateConfig("server_config.freeze_battle_combatants", enabled)) {
                logger.warn("Failed to set \"server_config.freeze_battle_combatants\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set freeze_battle_combatants to \"" + enabled + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set freeze_battle_combatants to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(enabled));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ignore_battle_types").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent response = Component.literal((String)"Use ");
                MutableComponent subResponse = Component.literal((String)"/tbm-server-edit ignore_battle_types add/remove <category> ");
                subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.YELLOW));
                response.getSiblings().add(subResponse);
                subResponse = Component.literal((String)"ignore_battle_types is currently: [");
                response.getSiblings().add(subResponse);
                boolean isFirst = true;
                for (String category : proxy.getConfig().getIgnoreBattleTypes()) {
                    if (!isFirst) {
                        response.getSiblings().add(Component.literal((String)", "));
                    }
                    subResponse = Component.literal((String)category);
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_battle_types remove " + category)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to remove category"))));
                    response.getSiblings().add(subResponse);
                    isFirst = false;
                }
                response.getSiblings().add(Component.literal((String)"] "));
                return response;
            }, false);
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"add").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"/tbm-server-edit ignore_battle_types add <category>"));
            return 1;
        })).then(Commands.argument((String)"category", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String category = StringArgumentType.getString((CommandContext)c, (String)"category");
            if (proxy.getConfig().addIgnoreBattleType(category) && proxy.getConfig().updateConfigAppendToStringArray("server_config.ignore_battle_types", category)) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully appended category \"");
                    MutableComponent sub = Component.literal((String)category);
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(sub);
                    sub = Component.literal((String)"\" to ignore_battle_types");
                    response.getSiblings().add(sub);
                    return response;
                }, true);
                return 1;
            }
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to append category \"" + category + "\" to ignore_battle_types")));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"/tbm-server-edit ignore_battle_types remove <category>"));
            return 1;
        })).then(Commands.argument((String)"category", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String category = StringArgumentType.getString((CommandContext)c, (String)"category");
            if (proxy.getConfig().removeIgnoreBattleType(category) && proxy.getConfig().updateConfigRemoveFromStringArray("server_config.ignore_battle_types", category)) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully removed category \"");
                    MutableComponent sub = Component.literal((String)category);
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(sub);
                    sub = Component.literal((String)"\" from ignore_battle_types");
                    response.getSiblings().add(sub);
                    return response;
                }, true);
                return 1;
            }
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to remove category \"" + category + "\" from ignore_battle_types")));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"player_speed").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit player_speed <0-100>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"speed");
            proxy.getConfig().setPlayerSpeed(speed);
            speed = proxy.getConfig().getPlayerSpeed();
            if (!proxy.getConfig().updateConfig("server_config.player_speed", speed)) {
                logger.warn("Failed to set \"server_config.player_speed\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set player_speed to \"" + speed + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set player_speed to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getPlayerSpeed()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"player_haste_speed").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit player_haste_speed <0-100>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"haste_speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int haste_speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"haste_speed");
            proxy.getConfig().setPlayerHasteSpeed(haste_speed);
            haste_speed = proxy.getConfig().getPlayerHasteSpeed();
            if (!proxy.getConfig().updateConfig("server_config.player_haste_speed", haste_speed)) {
                logger.warn("Failed to set \"server_config.player_haste_speed\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set player_haste_speed to \"" + haste_speed + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set player_haste_speed to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getPlayerHasteSpeed()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"player_slow_speed").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit player_slow_speed <0-100>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"slow_speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int slow_speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"slow_speed");
            proxy.getConfig().setPlayerSlowSpeed(slow_speed);
            slow_speed = proxy.getConfig().getPlayerSlowSpeed();
            if (!proxy.getConfig().updateConfig("server_config.player_slow_speed", slow_speed)) {
                logger.warn("Failed to set \"server_config.player_slow_speed\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set player_slow_speed to \"" + slow_speed + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set player_slow_speed to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getPlayerSlowSpeed()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"player_attack_probability").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit player_attack_probability <1-100>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"probability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int probability = IntegerArgumentType.getInteger((CommandContext)c, (String)"probability");
            proxy.getConfig().setPlayerAttackProbability(probability);
            probability = proxy.getConfig().getPlayerAttackProbability();
            if (!proxy.getConfig().updateConfig("server_config.player_attack_probability", probability)) {
                logger.warn("Failed to set \"server_config.player_attack_probability\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set player_attack_probability to \"" + probability + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set player_attack_probability to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getPlayerAttackProbability()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"player_evasion").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit player_evasion <0-100>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"evasion", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int evasion = IntegerArgumentType.getInteger((CommandContext)c, (String)"evasion");
            proxy.getConfig().setPlayerEvasion(evasion);
            evasion = proxy.getConfig().getPlayerEvasion();
            if (!proxy.getConfig().updateConfig("server_config.player_evasion", evasion)) {
                logger.warn("Failed to set \"server_config.player_evasion\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set player_evasion to \"" + evasion + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set player_evasion to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getPlayerEvasion()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"defense_duration").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit defense_duration <0-5>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"defends", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int defends = IntegerArgumentType.getInteger((CommandContext)c, (String)"defends");
            proxy.getConfig().setDefenseDuration(defends);
            defends = proxy.getConfig().getDefenseDuration();
            if (!proxy.getConfig().updateConfig("server_config.defense_duration", defends)) {
                logger.warn("Failed to set \"server_config.defense_duration\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set defense_druation to \"" + defends + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set defense_duration to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getDefenseDuration()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"flee_good_probability").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit flee_good_probability <1-100>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"probability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int probability = IntegerArgumentType.getInteger((CommandContext)c, (String)"probability");
            proxy.getConfig().setFleeGoodProbability(probability);
            probability = proxy.getConfig().getFleeGoodProbability();
            if (!proxy.getConfig().updateConfig("server_config.flee_good_probability", probability)) {
                logger.warn("Failed to set \"server_config.flee_good_probability\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set flee_good_probability to \"" + probability + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set flee_good_probability to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getFleeGoodProbability()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"flee_bad_probability").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit flee_bad_probability <1-100>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"probability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int probability = IntegerArgumentType.getInteger((CommandContext)c, (String)"probability");
            proxy.getConfig().setFleeBadProbability(probability);
            probability = proxy.getConfig().getFleeBadProbability();
            if (!proxy.getConfig().updateConfig("server_config.flee_bad_probability", probability)) {
                logger.warn("Failed to set \"server_config.flee_bad_probability\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set flee_bad_probability to \"" + probability + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set flee_bad_probability to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getFleeBadProbability()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"minimum_hit_percentage").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit minimum_hit_percentage <1-100>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"percentage", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int percentage = IntegerArgumentType.getInteger((CommandContext)c, (String)"percentage");
            proxy.getConfig().setMinimumHitPercentage(percentage);
            percentage = proxy.getConfig().getMinimumHitPercentage();
            if (!proxy.getConfig().updateConfig("server_config.minimum_hit_percentage", percentage)) {
                logger.warn("Failed to set \"server_config.minimum_hit_percentage\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set minimum_hit_percentage to \"" + percentage + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set minimum_hit_percentage to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getMinimumHitPercentage()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"battle_turn_wait_forever").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit battle_turn_wait_forever <true/false>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)c, (String)"enabled");
            proxy.getConfig().setBattleDecisionDurationForever(enabled);
            if (!proxy.getConfig().updateConfig("server_config.battle_turn_wait_forever", enabled)) {
                logger.warn("Failed to set \"server_config.battle_turn_wait_forever\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set battle_turn_wait_forever to \"" + (enabled ? "true" : "false") + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set battle_turn_wait_forever to: ");
                    MutableComponent subResponse = Component.literal((String)(enabled ? "true" : "false"));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"battle_turn_time_seconds").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit battle_turn_time_seconds <5-60>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int seconds = IntegerArgumentType.getInteger((CommandContext)c, (String)"seconds");
            proxy.getConfig().setDecisionDurationSeconds(seconds);
            seconds = proxy.getConfig().getDecisionDurationSeconds();
            if (!proxy.getConfig().updateConfig("server_config.battle_turn_time_seconds", seconds)) {
                logger.warn("Failed to set \"server_config.battle_turn_time_seconds\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set battle_turn_time_seconds to \"" + seconds + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set battle_turn_time_seconds to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getDecisionDurationSeconds()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"creeper_explode_turn").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit creeper_explode_turn <1-10>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"turns", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int turns = IntegerArgumentType.getInteger((CommandContext)c, (String)"turns");
            proxy.getConfig().setCreeperExplodeTurn(turns);
            turns = proxy.getConfig().getCreeperExplodeTurn();
            if (!proxy.getConfig().updateConfig("server_config.creeper_explode_turn", turns)) {
                logger.warn("Failed to set \"server_config.creeper_explode_turn\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set creeper_explode_turn to \"" + turns + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set creeper_explode_turn to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(proxy.getConfig().getCreeperExplodeTurn()));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"creeper_stop_explode_on_leave_battle").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit creeper_stop_explode_on_leave_battle <true/false>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"stop_explode_on_leave", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean stop_explode_on_leave = BoolArgumentType.getBool((CommandContext)c, (String)"stop_explode_on_leave");
            proxy.getConfig().setCreeperStopExplodeOnLeaveBattle(stop_explode_on_leave);
            if (!proxy.getConfig().updateConfig("server_config.creeper_stop_explode_on_leave_battle", stop_explode_on_leave)) {
                logger.warn("Failed to set \"server_config.creeper_stop_explode_on_leave_battle\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set creeper_stop_explode_on_leave_battle to \"" + stop_explode_on_leave + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set creeper_stop_explode_on_leave_battle to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(stop_explode_on_leave));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"creeper_always_allow_damage").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit creeper_always_allow_damage <true/false>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"allow_damage", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean allow_damage = BoolArgumentType.getBool((CommandContext)c, (String)"allow_damage");
            proxy.getConfig().setCreeperAlwaysAllowDamage(allow_damage);
            if (!proxy.getConfig().updateConfig("server_config.creeper_always_allow_damage", allow_damage)) {
                logger.warn("Failed to set \"server_config.creeper_always_allow_damage\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set creeper_always_allow_damage to \"" + allow_damage + "\" in config file!")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set creeper_always_allow_damage to: ");
                    MutableComponent subResponse = Component.literal((String)String.valueOf(allow_damage));
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(subResponse);
                    return response;
                }, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ignore_damage_sources").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent response = Component.literal((String)"Use ");
                MutableComponent subResponse = Component.literal((String)"/tbm-server-edit ignore_damage_sources add/remove <type> ");
                subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.YELLOW));
                response.getSiblings().add(subResponse);
                subResponse = Component.literal((String)"ignore_damage_sources is currently: [");
                response.getSiblings().add(subResponse);
                boolean isFirst = true;
                for (String type : proxy.getConfig().getIgnoreHurtDamageSources()) {
                    if (!isFirst) {
                        response.getSiblings().add(Component.literal((String)", "));
                    }
                    subResponse = Component.literal((String)type);
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_damage_sources remove " + type)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to remove type"))));
                    response.getSiblings().add(subResponse);
                    isFirst = false;
                }
                response.getSiblings().add(Component.literal((String)"] "));
                subResponse = Component.literal((String)"Possible Damage Sources: [");
                response.getSiblings().add(subResponse);
                isFirst = true;
                for (String type : proxy.getConfig().getPossibleIgnoreHurtDamageSources()) {
                    if (!isFirst) {
                        response.getSiblings().add(Component.literal((String)", "));
                    }
                    subResponse = Component.literal((String)type);
                    subResponse.setStyle(subResponse.getStyle().withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_damage_sources add " + type)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to add type"))));
                    response.getSiblings().add(subResponse);
                    isFirst = false;
                }
                response.getSiblings().add(Component.literal((String)"] "));
                return response;
            }, false);
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"add").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"/tbm-server-edit ignore_damage_sources add <type>"));
            return 1;
        })).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String type = StringArgumentType.getString((CommandContext)c, (String)"type");
            if (proxy.getConfig().addIgnoreHurtDamageSource(type) && proxy.getConfig().updateConfigAppendToStringArray("server_config.ignore_damage_sources", type)) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully appended Damage Source type \"");
                    MutableComponent sub = Component.literal((String)type);
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(sub);
                    sub = Component.literal((String)"\" to ignore_damage_sources");
                    response.getSiblings().add(sub);
                    return response;
                }, true);
                return 1;
            }
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to append type \"" + type + "\" to ignore_damage_sources")));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"/tbm-server-edit ignore_damage_sources remove <type>"));
            return 1;
        })).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String type = StringArgumentType.getString((CommandContext)c, (String)"type");
            if (proxy.getConfig().removeIgnoreHurtDamageSource(type) && proxy.getConfig().updateConfigRemoveFromStringArray("server_config.ignore_damage_sources", type)) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully removed category \"");
                    MutableComponent sub = Component.literal((String)type);
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(sub);
                    sub = Component.literal((String)"\" from ignore_damage_sources");
                    response.getSiblings().add(sub);
                    return response;
                }, true);
                return 1;
            }
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to remove type \"" + type + "\" from ignore_damage_sources")));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"player_only_battles").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                MutableComponent parent = Component.literal((String)"Use ");
                MutableComponent sub = Component.literal((String)"/tbm-server-edit player_only_battles <true/false>");
                sub.setStyle(sub.getStyle().withColor(ChatFormatting.YELLOW));
                parent.getSiblings().add(sub);
                return parent;
            }, false);
            return 1;
        })).then(Commands.argument((String)"player_only_battles", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean player_only_battles = BoolArgumentType.getBool((CommandContext)c, (String)"player_only_battles");
            proxy.getConfig().setIsPlayerOnlyBattles(player_only_battles);
            if (!proxy.getConfig().updateConfig("server_config.player_only_battles", player_only_battles)) {
                logger.warn("Failed to set \"server_config.player_only_battles\" in config file!");
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Failed to set player_only_battles to \"" + player_only_battles + "\" in config file")));
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> {
                    MutableComponent response = Component.literal((String)"Successfully set player_only_battles to: ");
                    MutableComponent sub = Component.literal((String)String.valueOf(player_only_battles));
                    sub.setStyle(sub.getStyle().withColor(ChatFormatting.GREEN));
                    response.getSiblings().add(sub);
                    return response;
                }, true);
            }
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"tbm-client-edit").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketClientGUI(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        }));
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent ignoredEvent) {
        logger.debug("About to cleanup BattleManager");
        if (proxy.cleanupBattleManager()) {
            logger.debug("Cleaned up BattleManager");
        }
    }
}

