/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.jetbrains.annotations.NotNull;

public class PacketBattleMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketBattleMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"com_burnedkirby_turnbasedminecraft", (String)"network_packetbattlemessage"));
    public static final StreamCodec<ByteBuf, PacketBattleMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.map(MessageType::valueOf, MessageType::getValue), PacketBattleMessage::getMessageType, (StreamCodec)ByteBufCodecs.INT, PacketBattleMessage::getEntityIDFrom, (StreamCodec)ByteBufCodecs.INT, PacketBattleMessage::getEntityIDTo, (StreamCodec)ByteBufCodecs.STRING_UTF8.map(Utility::deserializeDimension, Utility::serializeDimension), PacketBattleMessage::getDimension, (StreamCodec)ByteBufCodecs.INT, PacketBattleMessage::getAmount, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketBattleMessage::getCustom, PacketBattleMessage::new);
    MessageType messageType;
    int entityIDFrom;
    int entityIDTo;
    int amount;
    String custom;
    ResourceKey<Level> dimension;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public int getEntityIDFrom() {
        return this.entityIDFrom;
    }

    public int getEntityIDTo() {
        return this.entityIDTo;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getCustom() {
        return this.custom;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public String getDimensionSerialized() {
        return Utility.serializeDimension(this.dimension);
    }

    public PacketBattleMessage() {
        this.custom = new String();
    }

    public PacketBattleMessage(MessageType messageType, int entityIDFrom, int entityIDTo, ResourceKey<Level> dimension, int amount) {
        this.messageType = messageType;
        this.entityIDFrom = entityIDFrom;
        this.entityIDTo = entityIDTo;
        this.dimension = dimension;
        this.amount = amount;
        this.custom = new String();
    }

    public PacketBattleMessage(MessageType messageType, int entityIDFrom, int entityIDTo, ResourceKey<Level> dimension, int amount, String custom) {
        this.messageType = messageType;
        this.entityIDFrom = entityIDFrom;
        this.entityIDTo = entityIDTo;
        this.dimension = dimension;
        this.amount = amount;
        this.custom = custom;
    }

    public static enum MessageType {
        ENTERED(0),
        FLEE(1),
        DIED(2),
        ENDED(3),
        ATTACK(4),
        DEFEND(5),
        DEFENSE_DAMAGE(6),
        MISS(7),
        DEFENDING(8),
        DID_NOTHING(9),
        USED_ITEM(10),
        TURN_BEGIN(11),
        TURN_END(12),
        SWITCHED_ITEM(13),
        WAS_AFFECTED(14),
        BECAME_CREATIVE(15),
        FIRED_ARROW(16),
        ARROW_HIT(17),
        BOW_NO_AMMO(18),
        CREEPER_WAIT(19),
        CREEPER_WAIT_FINAL(20),
        CREEPER_EXPLODE(21),
        CROSSBOW_NO_AMMO(22);

        private int value;
        private static Map<Integer, MessageType> map;

        private MessageType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MessageType valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, MessageType>();
            for (MessageType type : MessageType.values()) {
                map.put(type.getValue(), type);
            }
        }
    }

    public static class PayloadHandler
    implements IPayloadHandler<PacketBattleMessage> {
        public void handle(@NotNull PacketBattleMessage pkt, IPayloadContext ctx) {
            ctx.enqueueWork(() -> {
                if (FMLEnvironment.dist.isClient()) {
                    TurnBasedMinecraftMod.proxy.handlePacket(pkt, ctx);
                }
            }).exceptionally(e -> {
                ctx.disconnect((Component)Component.literal((String)("Exception handling PacketBattleMessage! " + e.getMessage())));
                return null;
            });
        }
    }

    public static enum UsedItemAction {
        USED_NOTHING(0),
        USED_INVALID(1),
        USED_FOOD(2),
        USED_POTION(3);

        private int value;
        private static Map<Integer, UsedItemAction> map;

        private UsedItemAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UsedItemAction valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, UsedItemAction>();
            for (UsedItemAction type : UsedItemAction.values()) {
                map.put(type.getValue(), type);
            }
        }
    }
}

